/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AutoMapperProperties;
import io.github.linpeilie.processor.metadata.AbstractAdapterMethodMetadata;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public abstract class AbstractAdapterMapperGenerator {
    public void write(ProcessingEnvironment processingEnv, Collection<AbstractAdapterMethodMetadata> adapterMethods, String adapterClassName) {
        try (Writer writer = processingEnv.getFiler().createSourceFile(this.adapterPackage() + "." + adapterClassName, new Element[0]).openWriter();){
            JavaFile.builder((String)this.adapterPackage(), (TypeSpec)this.createTypeSpec(adapterMethods, adapterClassName)).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + adapterClassName + " output file: " + e.getMessage());
        }
    }

    protected abstract TypeSpec createTypeSpec(Collection<AbstractAdapterMethodMetadata> var1, String var2);

    protected String adapterPackage() {
        return AutoMapperProperties.getAdapterPackage();
    }

    protected MethodSpec buildProxyMethod(AbstractAdapterMethodMetadata adapterMethodMetadata) {
        CodeBlock targetCode = adapterMethodMetadata.isStatic() ? CodeBlock.of((String)"return $T.$N($N);", (Object[])new Object[]{adapterMethodMetadata.getMapper(), adapterMethodMetadata.getMapperMethodName(), "param"}) : this.proxyMethodTarget(adapterMethodMetadata);
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)adapterMethodMetadata.getSource(), (String)"param", (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)adapterMethodMetadata.getMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterSpec).returns(adapterMethodMetadata.getReturn()).addCode(targetCode).build();
    }

    protected abstract CodeBlock proxyMethodTarget(AbstractAdapterMethodMetadata var1);
}

