/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.generator;

import cn.hutool.core.util.StrUtil;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.metadata.AutoMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMappingMetadata;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;

public class AutoMapperGenerator {
    public void write(AutoMapperMetadata metadata, Writer writer) {
        try {
            JavaFile.builder((String)metadata.mapperPackage(), (TypeSpec)this.createTypeSpec(metadata)).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    private TypeSpec createTypeSpec(AutoMapperMetadata metadata) {
        ParameterizedTypeName converterName = ParameterizedTypeName.get((ClassName)metadata.getSuperClass(), (TypeName[])metadata.getSuperGenerics());
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)metadata.mapperName()).addSuperinterface((TypeName)converterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.buildGeneratedMapperAnnotationSpec(metadata));
        if (metadata.getFieldMappingList() != null && !metadata.getFieldMappingList().isEmpty()) {
            ParameterSpec source = ParameterSpec.builder((TypeName)metadata.getSourceClassName(), (String)"source", (Modifier[])new Modifier[0]).build();
            ParameterSpec target = ParameterSpec.builder((TypeName)metadata.getTargetClassName(), (String)"target", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"MappingTarget", (String[])new String[0])).build()).build();
            builder.addMethod(this.addConvertMethodSpec(Collections.singletonList(source), metadata.getFieldMappingList(), metadata.getTargetClassName()));
            builder.addMethod(this.addConvertMethodSpec(Arrays.asList(source, target), metadata.getFieldMappingList(), metadata.getTargetClassName()));
        }
        return builder.build();
    }

    private MethodSpec addConvertMethodSpec(List<ParameterSpec> parameterSpecs, List<AutoMappingMetadata> autoMappingMetadataList, ClassName target) {
        return MethodSpec.methodBuilder((String)"convert").addParameters(parameterSpecs).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotations(this.buildMappingAnnotations(autoMappingMetadataList)).returns((TypeName)target).build();
    }

    private List<AnnotationSpec> buildMappingAnnotations(List<AutoMappingMetadata> autoMappingMetadataList) {
        return autoMappingMetadataList.stream().map(autoMappingMetadata -> {
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"Mapping", (String[])new String[0])).addMember("target", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getTarget()}).build()).addMember("ignore", CodeBlock.builder().add(String.valueOf(autoMappingMetadata.isIgnore()), new Object[0]).build());
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getDateFormat())) {
                builder.addMember("dateFormat", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getDateFormat()}).build());
            }
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getNumberFormat())) {
                builder.addMember("numberFormat", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getNumberFormat()}).build());
            }
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getDefaultValue())) {
                builder.addMember("defaultValue", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getDefaultValue()}).build());
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{autoMappingMetadata.getExpression()})) {
                builder.addMember("expression", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getExpression()}).build());
            } else {
                builder.addMember("source", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getSource()}).build());
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    private AnnotationSpec buildGeneratedMapperAnnotationSpec(AutoMapperMetadata metadata) {
        List usesClassNameList = Optional.ofNullable(metadata.getUsesClassNameList()).orElse(new ArrayList());
        CodeBlock configCodeBlock = CodeBlock.builder().add("$T.class", new Object[]{metadata.getMapstructConfigClass()}).build();
        CodeBlock.Builder usesCodeBuilder = CodeBlock.builder().add("{", new Object[0]);
        for (int i = 0; i < usesClassNameList.size(); ++i) {
            usesCodeBuilder.add("$T.class", new Object[]{usesClassNameList.get(i)});
            if (i == usesClassNameList.size() - 1) continue;
            usesCodeBuilder.add(",", new Object[0]);
        }
        CodeBlock usesCodeBlock = usesCodeBuilder.add("}", new Object[0]).build();
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"Mapper", (String[])new String[0])).addMember("config", configCodeBlock).addMember("uses", usesCodeBlock);
        return builder.build();
    }
}

