/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.metadata.AutoMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMappingMetadata;
import io.github.linpeilie.utils.ArrayUtil;
import io.github.linpeilie.utils.CollectionUtils;
import io.github.linpeilie.utils.StrUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class AutoMapperGenerator {
    public static final String CONVERT_METHOD_NAME = "convert";

    public void write(AutoMapperMetadata metadata, ProcessingEnvironment processingEnv, Writer writer) {
        try {
            JavaFile.builder((String)metadata.mapperPackage(), (TypeSpec)this.createTypeSpec(processingEnv, metadata)).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TypeSpec createTypeSpec(ProcessingEnvironment processingEnv, AutoMapperMetadata metadata) {
        boolean targetIsImmutable;
        ParameterizedTypeName converterName = ParameterizedTypeName.get((ClassName)metadata.getSuperClass(), (TypeName[])metadata.getSuperGenerics());
        ClassName targetClassName = metadata.getTargetClassName();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)metadata.mapperName()).addSuperinterface((TypeName)converterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.buildGeneratedMapperAnnotationSpec(metadata));
        ParameterSpec source = ParameterSpec.builder((TypeName)metadata.getSourceClassName(), (String)"source", (Modifier[])new Modifier[0]).build();
        ParameterSpec target = ParameterSpec.builder((TypeName)targetClassName, (String)"target", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"MappingTarget", (String[])new String[0])).build()).build();
        ParameterSpec context = ParameterSpec.builder((TypeName)ClassName.get((String)"io.github.linpeilie", (String)"CycleAvoidingMappingContext", (String[])new String[0]), (String)"context", (Modifier[])new Modifier[0]).addAnnotation(ClassName.get((String)"org.mapstruct", (String)"Context", (String[])new String[0])).build();
        if (metadata.getFieldMappingList() != null && !metadata.getFieldMappingList().isEmpty()) {
            builder.addMethod(this.addConvertMethodSpec(metadata.isCycleAvoiding() ? CollectionUtils.newArrayList((Object[])new ParameterSpec[]{source, context}) : Collections.singletonList(source), metadata.getFieldMappingList(), targetClassName, CONVERT_METHOD_NAME));
        }
        if (targetIsImmutable = this.classIsImmutable(processingEnv, targetClassName)) {
            builder.addMethod(this.addEmptyConvertMethodForImmutableEntity(metadata.isCycleAvoiding() ? CollectionUtils.newArrayList((Object[])new ParameterSpec[]{source, target, context}) : CollectionUtils.newArrayList((Object[])new ParameterSpec[]{source, target}), targetClassName, CONVERT_METHOD_NAME));
        } else if (metadata.getFieldMappingList() != null && !metadata.getFieldMappingList().isEmpty()) {
            builder.addMethod(this.addConvertMethodSpec(metadata.isCycleAvoiding() ? CollectionUtils.newArrayList((Object[])new ParameterSpec[]{source, target, context}) : CollectionUtils.newArrayList((Object[])new ParameterSpec[]{source, target}), metadata.getFieldMappingList(), targetClassName, CONVERT_METHOD_NAME));
        }
        return builder.build();
    }

    private MethodSpec addEmptyConvertMethodForImmutableEntity(List<ParameterSpec> parameterSpecs, ClassName targetClassName, String methodName) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameters(parameterSpecs).returns((TypeName)targetClassName).addCode("return target;", new Object[0]);
        return builder.build();
    }

    private boolean classIsImmutable(ProcessingEnvironment processingEnv, ClassName className) {
        TypeElement targetElement = processingEnv.getElementUtils().getTypeElement(className.reflectionName().replaceAll("\\$", "."));
        List<? extends AnnotationMirror> annotationMirrors = targetElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Immutable")) continue;
            return true;
        }
        return false;
    }

    private MethodSpec addConvertMethodSpec(List<ParameterSpec> parameterSpecs, List<AutoMappingMetadata> autoMappingMetadataList, ClassName target, String methodName) {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)methodName).addParameters(parameterSpecs).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addAnnotation(ClassName.get((String)"io.github.linpeilie.annotations", (String)"DoIgnore", (String[])new String[0])).returns((TypeName)target);
        if (CollectionUtils.isNotEmpty(autoMappingMetadataList)) {
            methodSpecBuilder.addAnnotations(this.buildMappingAnnotations(autoMappingMetadataList));
        }
        return methodSpecBuilder.build();
    }

    private List<AnnotationSpec> buildMappingAnnotations(List<AutoMappingMetadata> autoMappingMetadataList) {
        return autoMappingMetadataList.stream().map(autoMappingMetadata -> {
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"Mapping", (String[])new String[0])).addMember("target", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getTarget()}).build()).addMember("ignore", CodeBlock.builder().add(String.valueOf(autoMappingMetadata.isIgnore()), new Object[0]).build());
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getDateFormat())) {
                builder.addMember("dateFormat", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getDateFormat()}).build());
            }
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getNumberFormat())) {
                builder.addMember("numberFormat", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getNumberFormat()}).build());
            }
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getDefaultValue())) {
                builder.addMember("defaultValue", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getDefaultValue()}).build());
            }
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getExpression())) {
                builder.addMember("expression", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getExpression()}).build());
            } else {
                builder.addMember("source", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getSource()}).build());
            }
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getDefaultExpression())) {
                builder.addMember("defaultExpression", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getDefaultExpression()}).build());
            }
            if (StrUtil.isNotEmpty((CharSequence)autoMappingMetadata.getConditionExpression())) {
                builder.addMember("conditionExpression", CodeBlock.builder().add("$S", new Object[]{autoMappingMetadata.getConditionExpression()}).build());
            }
            if (ArrayUtil.isNotEmpty((Object[])autoMappingMetadata.getQualifiedByName())) {
                builder.addMember("qualifiedByName", CodeBlock.builder().add("$L", new Object[]{"{" + ArrayUtil.join((Object[])autoMappingMetadata.getQualifiedByName(), (CharSequence)",", (String)"\"", (String)"\"") + "}"}).build());
            }
            if (ArrayUtil.isNotEmpty((Object[])autoMappingMetadata.getConditionQualifiedByName())) {
                builder.addMember("conditionQualifiedByName", CodeBlock.builder().add("$L", new Object[]{"{" + ArrayUtil.join((Object[])autoMappingMetadata.getConditionQualifiedByName(), (CharSequence)",", (String)"\"", (String)"\"") + "}"}).build());
            }
            if (ArrayUtil.isNotEmpty((Object[])autoMappingMetadata.getDependsOn())) {
                builder.addMember("dependsOn", CodeBlock.builder().add("$L", new Object[]{"{" + ArrayUtil.join((Object[])autoMappingMetadata.getDependsOn(), (CharSequence)",", (String)"\"", (String)"\"") + "}"}).build());
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    private AnnotationSpec buildGeneratedMapperAnnotationSpec(AutoMapperMetadata metadata) {
        List usesClassNameList = Optional.ofNullable(metadata.getUsesClassNameList()).orElse(new ArrayList());
        List importsClassNameList = Optional.ofNullable(metadata.getImportsClassNameList()).orElse(new ArrayList());
        CodeBlock configCodeBlock = CodeBlock.builder().add("$T.class", new Object[]{metadata.getMapstructConfigClass()}).build();
        CodeBlock.Builder usesCodeBuilder = CodeBlock.builder().add("{", new Object[0]);
        for (int i = 0; i < usesClassNameList.size(); ++i) {
            usesCodeBuilder.add("$T.class", new Object[]{usesClassNameList.get(i)});
            if (i == usesClassNameList.size() - 1) continue;
            usesCodeBuilder.add(",", new Object[0]);
        }
        CodeBlock usesCodeBlock = usesCodeBuilder.add("}", new Object[0]).build();
        CodeBlock.Builder importsCodeBuilder = CodeBlock.builder().add("{", new Object[0]);
        for (int i = 0; i < importsClassNameList.size(); ++i) {
            importsCodeBuilder.add("$T.class", new Object[]{importsClassNameList.get(i)});
            if (i == importsClassNameList.size() - 1) continue;
            importsCodeBuilder.add(",", new Object[0]);
        }
        CodeBlock importsCodeBlock = importsCodeBuilder.add("}", new Object[0]).build();
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"Mapper", (String[])new String[0])).addMember("config", configCodeBlock).addMember("uses", usesCodeBlock).addMember("imports", importsCodeBlock);
        return builder.build();
    }
}

