package io.github.linpeilie.processor.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.tools.gem.Gem;
import org.mapstruct.tools.gem.GemValue;

import javax.lang.model.type.TypeMirror;

public class MapperConfigGem implements Gem {

    private final GemValue<String> mapperPackage;
    private final GemValue<String> unmappedSourcePolicy;
    private final GemValue<String> unmappedTargetPolicy;
    private final GemValue<String> typeConversionPolicy;
    private final GemValue<String> collectionMappingStrategy;
    private final GemValue<String> nullValueMappingStrategy;
    private final GemValue<String> nullValueIterableMappingStrategy;
    private final GemValue<String> nullValueMapMappingStrategy;
    private final GemValue<String> nullValuePropertyMappingStrategy;
    private final GemValue<String> nullValueCheckStrategy;
    private final GemValue<TypeMirror> mappingControl;
    private final GemValue<TypeMirror> unexpectedValueMappingException;
    private final GemValue<Boolean> suppressTimestampInGenerated;
    private final GemValue<BuilderGem> builder;
    private final GemValue<String> adapterPackage;
    private final GemValue<String> adapterClassName;
    private final GemValue<String> mapAdapterClassName;
    private final GemValue<String> autoConfigPackage;
    private final GemValue<String> autoMapperConfigClassName;
    private final GemValue<String> autoMapMapperConfigClassName;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private MapperConfigGem( BuilderImpl builder ) {
        this.mapperPackage = builder.mapperPackage;
        this.unmappedSourcePolicy = builder.unmappedSourcePolicy;
        this.unmappedTargetPolicy = builder.unmappedTargetPolicy;
        this.typeConversionPolicy = builder.typeConversionPolicy;
        this.collectionMappingStrategy = builder.collectionMappingStrategy;
        this.nullValueMappingStrategy = builder.nullValueMappingStrategy;
        this.nullValueIterableMappingStrategy = builder.nullValueIterableMappingStrategy;
        this.nullValueMapMappingStrategy = builder.nullValueMapMappingStrategy;
        this.nullValuePropertyMappingStrategy = builder.nullValuePropertyMappingStrategy;
        this.nullValueCheckStrategy = builder.nullValueCheckStrategy;
        this.mappingControl = builder.mappingControl;
        this.unexpectedValueMappingException = builder.unexpectedValueMappingException;
        this.suppressTimestampInGenerated = builder.suppressTimestampInGenerated;
        this.builder = builder.builder;
        this.adapterPackage = builder.adapterPackage;
        this.adapterClassName = builder.adapterClassName;
        this.mapAdapterClassName = builder.mapAdapterClassName;
        this.autoConfigPackage = builder.autoConfigPackage;
        this.autoMapperConfigClassName = builder.autoMapperConfigClassName;
        this.autoMapMapperConfigClassName = builder.autoMapMapperConfigClassName;
        isValid = ( this.mapperPackage != null ? this.mapperPackage.isValid() : false )
               && ( this.unmappedSourcePolicy != null ? this.unmappedSourcePolicy.isValid() : false )
               && ( this.unmappedTargetPolicy != null ? this.unmappedTargetPolicy.isValid() : false )
               && ( this.typeConversionPolicy != null ? this.typeConversionPolicy.isValid() : false )
               && ( this.collectionMappingStrategy != null ? this.collectionMappingStrategy.isValid() : false )
               && ( this.nullValueMappingStrategy != null ? this.nullValueMappingStrategy.isValid() : false )
               && ( this.nullValueIterableMappingStrategy != null ? this.nullValueIterableMappingStrategy.isValid() : false )
               && ( this.nullValueMapMappingStrategy != null ? this.nullValueMapMappingStrategy.isValid() : false )
               && ( this.nullValuePropertyMappingStrategy != null ? this.nullValuePropertyMappingStrategy.isValid() : false )
               && ( this.nullValueCheckStrategy != null ? this.nullValueCheckStrategy.isValid() : false )
               && ( this.mappingControl != null ? this.mappingControl.isValid() : false )
               && ( this.unexpectedValueMappingException != null ? this.unexpectedValueMappingException.isValid() : false )
               && ( this.suppressTimestampInGenerated != null ? this.suppressTimestampInGenerated.isValid() : false )
               && ( this.builder != null ? this.builder.isValid() : false )
               && ( this.adapterPackage != null ? this.adapterPackage.isValid() : false )
               && ( this.adapterClassName != null ? this.adapterClassName.isValid() : false )
               && ( this.mapAdapterClassName != null ? this.mapAdapterClassName.isValid() : false )
               && ( this.autoConfigPackage != null ? this.autoConfigPackage.isValid() : false )
               && ( this.autoMapperConfigClassName != null ? this.autoMapperConfigClassName.isValid() : false )
               && ( this.autoMapMapperConfigClassName != null ? this.autoMapMapperConfigClassName.isValid() : false );
        mirror = builder.mirror;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#mapperPackage}
    */
    public GemValue<String> mapperPackage( ) {
        return mapperPackage;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#unmappedSourcePolicy}
    */
    public GemValue<String> unmappedSourcePolicy( ) {
        return unmappedSourcePolicy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#unmappedTargetPolicy}
    */
    public GemValue<String> unmappedTargetPolicy( ) {
        return unmappedTargetPolicy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#typeConversionPolicy}
    */
    public GemValue<String> typeConversionPolicy( ) {
        return typeConversionPolicy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#collectionMappingStrategy}
    */
    public GemValue<String> collectionMappingStrategy( ) {
        return collectionMappingStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#nullValueMappingStrategy}
    */
    public GemValue<String> nullValueMappingStrategy( ) {
        return nullValueMappingStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#nullValueIterableMappingStrategy}
    */
    public GemValue<String> nullValueIterableMappingStrategy( ) {
        return nullValueIterableMappingStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#nullValueMapMappingStrategy}
    */
    public GemValue<String> nullValueMapMappingStrategy( ) {
        return nullValueMapMappingStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#nullValuePropertyMappingStrategy}
    */
    public GemValue<String> nullValuePropertyMappingStrategy( ) {
        return nullValuePropertyMappingStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#nullValueCheckStrategy}
    */
    public GemValue<String> nullValueCheckStrategy( ) {
        return nullValueCheckStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#mappingControl}
    */
    public GemValue<TypeMirror> mappingControl( ) {
        return mappingControl;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#unexpectedValueMappingException}
    */
    public GemValue<TypeMirror> unexpectedValueMappingException( ) {
        return unexpectedValueMappingException;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#suppressTimestampInGenerated}
    */
    public GemValue<Boolean> suppressTimestampInGenerated( ) {
        return suppressTimestampInGenerated;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#builder}
    */
    public GemValue<BuilderGem> builder( ) {
        return builder;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#adapterPackage}
    */
    public GemValue<String> adapterPackage( ) {
        return adapterPackage;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#adapterClassName}
    */
    public GemValue<String> adapterClassName( ) {
        return adapterClassName;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#mapAdapterClassName}
    */
    public GemValue<String> mapAdapterClassName( ) {
        return mapAdapterClassName;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#autoConfigPackage}
    */
    public GemValue<String> autoConfigPackage( ) {
        return autoConfigPackage;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#autoMapperConfigClassName}
    */
    public GemValue<String> autoMapperConfigClassName( ) {
        return autoMapperConfigClassName;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link MapperConfigGem#autoMapMapperConfigClassName}
    */
    public GemValue<String> autoMapMapperConfigClassName( ) {
        return autoMapMapperConfigClassName;
    }

    @Override
    public AnnotationMirror mirror( ) {
        return mirror;
    }

    @Override
    public boolean isValid( ) {
        return isValid;
    }

    public static MapperConfigGem  instanceOn(Element element) {
        return build( element, new BuilderImpl() );
    }

    public static MapperConfigGem instanceOn(AnnotationMirror mirror ) {
        return build( mirror, new BuilderImpl() );
    }

    public static  <T> T  build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream()
            .filter( a ->  "io.github.linpeilie.annotations.MapperConfig".contentEquals( ( ( TypeElement )a.getAnnotationType().asElement() ).getQualifiedName() ) )
            .findAny()
            .orElse( null );
        return build( mirror, builder );
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder ) {

        // return fast
        if ( mirror == null || builder == null ) {
            return null;
        }

        // fetch defaults from all defined values in the annotation type
        List<ExecutableElement> enclosed = ElementFilter.methodsIn( mirror.getAnnotationType().asElement().getEnclosedElements() );
        Map<String, AnnotationValue> defaultValues = new HashMap<>( enclosed.size() );
        enclosed.forEach( e -> defaultValues.put( e.getSimpleName().toString(), e.getDefaultValue() ) );

        // fetch all explicitely set annotation values in the annotation instance
        Map<String, AnnotationValue> values = new HashMap<>( enclosed.size() );
        mirror.getElementValues().entrySet().forEach( e -> values.put( e.getKey().getSimpleName().toString(), e.getValue() ) );

        // iterate and populate builder
        for ( String methodName : defaultValues.keySet() ) {

            if ( "mapperPackage".equals( methodName ) ) {
                builder.setMapperpackage( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "unmappedSourcePolicy".equals( methodName ) ) {
                builder.setUnmappedsourcepolicy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "unmappedTargetPolicy".equals( methodName ) ) {
                builder.setUnmappedtargetpolicy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "typeConversionPolicy".equals( methodName ) ) {
                builder.setTypeconversionpolicy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "collectionMappingStrategy".equals( methodName ) ) {
                builder.setCollectionmappingstrategy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "nullValueMappingStrategy".equals( methodName ) ) {
                builder.setNullvaluemappingstrategy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "nullValueIterableMappingStrategy".equals( methodName ) ) {
                builder.setNullvalueiterablemappingstrategy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "nullValueMapMappingStrategy".equals( methodName ) ) {
                builder.setNullvaluemapmappingstrategy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "nullValuePropertyMappingStrategy".equals( methodName ) ) {
                builder.setNullvaluepropertymappingstrategy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "nullValueCheckStrategy".equals( methodName ) ) {
                builder.setNullvaluecheckstrategy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "mappingControl".equals( methodName ) ) {
                builder.setMappingcontrol( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "unexpectedValueMappingException".equals( methodName ) ) {
                builder.setUnexpectedvaluemappingexception( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "suppressTimestampInGenerated".equals( methodName ) ) {
                builder.setSuppresstimestampingenerated( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), Boolean.class ) );
            }
            else if ( "builder".equals( methodName ) ) {
                builder.setBuilder( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), BuilderGem::instanceOn ) );
            }
            else if ( "adapterPackage".equals( methodName ) ) {
                builder.setAdapterpackage( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "adapterClassName".equals( methodName ) ) {
                builder.setAdapterclassname( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "mapAdapterClassName".equals( methodName ) ) {
                builder.setMapadapterclassname( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "autoConfigPackage".equals( methodName ) ) {
                builder.setAutoconfigpackage( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "autoMapperConfigClassName".equals( methodName ) ) {
                builder.setAutomapperconfigclassname( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "autoMapMapperConfigClassName".equals( methodName ) ) {
                builder.setAutomapmapperconfigclassname( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
        }
        builder.setMirror( mirror );
        return builder.build();
    }

    /**
     * A builder that can be implemented by the user to define custom logic e.g. in the
     * build method, prior to creating the annotation gem.
     */
    public interface Builder<T> {

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#mapperPackage}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setMapperpackage(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#unmappedSourcePolicy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setUnmappedsourcepolicy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#unmappedTargetPolicy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setUnmappedtargetpolicy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#typeConversionPolicy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setTypeconversionpolicy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#collectionMappingStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setCollectionmappingstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#nullValueMappingStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setNullvaluemappingstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#nullValueIterableMappingStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setNullvalueiterablemappingstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#nullValueMapMappingStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setNullvaluemapmappingstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#nullValuePropertyMappingStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setNullvaluepropertymappingstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#nullValueCheckStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setNullvaluecheckstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#mappingControl}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setMappingcontrol(GemValue<TypeMirror> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#unexpectedValueMappingException}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setUnexpectedvaluemappingexception(GemValue<TypeMirror> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#suppressTimestampInGenerated}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setSuppresstimestampingenerated(GemValue<Boolean> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#builder}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setBuilder(GemValue<BuilderGem> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#adapterPackage}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setAdapterpackage(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#adapterClassName}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setAdapterclassname(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#mapAdapterClassName}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setMapadapterclassname(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#autoConfigPackage}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setAutoconfigpackage(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#autoMapperConfigClassName}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setAutomapperconfigclassname(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link MapperConfigGem#autoMapMapperConfigClassName}
        *
        * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
        */
        Builder setAutomapmapperconfigclassname(GemValue<String> methodName );

        /**
         * Sets the annotation mirror
         *
         * @param mirror the mirror which this gem represents
         *
         * @return the {@link Builder} for this gem, representing {@link MapperConfigGem}
         */
          Builder setMirror( AnnotationMirror mirror );

        /**
         * The build method can be overriden in a custom custom implementation, which allows
         * the user to define his own custom validation on the annotation.
         *
         * @return the representation of the annotation
         */
        T build();
    }

    private static class BuilderImpl implements Builder<MapperConfigGem> {

        private GemValue<String> mapperPackage;
        private GemValue<String> unmappedSourcePolicy;
        private GemValue<String> unmappedTargetPolicy;
        private GemValue<String> typeConversionPolicy;
        private GemValue<String> collectionMappingStrategy;
        private GemValue<String> nullValueMappingStrategy;
        private GemValue<String> nullValueIterableMappingStrategy;
        private GemValue<String> nullValueMapMappingStrategy;
        private GemValue<String> nullValuePropertyMappingStrategy;
        private GemValue<String> nullValueCheckStrategy;
        private GemValue<TypeMirror> mappingControl;
        private GemValue<TypeMirror> unexpectedValueMappingException;
        private GemValue<Boolean> suppressTimestampInGenerated;
        private GemValue<BuilderGem> builder;
        private GemValue<String> adapterPackage;
        private GemValue<String> adapterClassName;
        private GemValue<String> mapAdapterClassName;
        private GemValue<String> autoConfigPackage;
        private GemValue<String> autoMapperConfigClassName;
        private GemValue<String> autoMapMapperConfigClassName;
        private AnnotationMirror mirror;

        public Builder setMapperpackage(GemValue<String> mapperPackage ) {
            this.mapperPackage = mapperPackage;
            return this;
        }

        public Builder setUnmappedsourcepolicy(GemValue<String> unmappedSourcePolicy ) {
            this.unmappedSourcePolicy = unmappedSourcePolicy;
            return this;
        }

        public Builder setUnmappedtargetpolicy(GemValue<String> unmappedTargetPolicy ) {
            this.unmappedTargetPolicy = unmappedTargetPolicy;
            return this;
        }

        public Builder setTypeconversionpolicy(GemValue<String> typeConversionPolicy ) {
            this.typeConversionPolicy = typeConversionPolicy;
            return this;
        }

        public Builder setCollectionmappingstrategy(GemValue<String> collectionMappingStrategy ) {
            this.collectionMappingStrategy = collectionMappingStrategy;
            return this;
        }

        public Builder setNullvaluemappingstrategy(GemValue<String> nullValueMappingStrategy ) {
            this.nullValueMappingStrategy = nullValueMappingStrategy;
            return this;
        }

        public Builder setNullvalueiterablemappingstrategy(GemValue<String> nullValueIterableMappingStrategy ) {
            this.nullValueIterableMappingStrategy = nullValueIterableMappingStrategy;
            return this;
        }

        public Builder setNullvaluemapmappingstrategy(GemValue<String> nullValueMapMappingStrategy ) {
            this.nullValueMapMappingStrategy = nullValueMapMappingStrategy;
            return this;
        }

        public Builder setNullvaluepropertymappingstrategy(GemValue<String> nullValuePropertyMappingStrategy ) {
            this.nullValuePropertyMappingStrategy = nullValuePropertyMappingStrategy;
            return this;
        }

        public Builder setNullvaluecheckstrategy(GemValue<String> nullValueCheckStrategy ) {
            this.nullValueCheckStrategy = nullValueCheckStrategy;
            return this;
        }

        public Builder setMappingcontrol(GemValue<TypeMirror> mappingControl ) {
            this.mappingControl = mappingControl;
            return this;
        }

        public Builder setUnexpectedvaluemappingexception(GemValue<TypeMirror> unexpectedValueMappingException ) {
            this.unexpectedValueMappingException = unexpectedValueMappingException;
            return this;
        }

        public Builder setSuppresstimestampingenerated(GemValue<Boolean> suppressTimestampInGenerated ) {
            this.suppressTimestampInGenerated = suppressTimestampInGenerated;
            return this;
        }

        public Builder setBuilder(GemValue<BuilderGem> builder ) {
            this.builder = builder;
            return this;
        }

        public Builder setAdapterpackage(GemValue<String> adapterPackage ) {
            this.adapterPackage = adapterPackage;
            return this;
        }

        public Builder setAdapterclassname(GemValue<String> adapterClassName ) {
            this.adapterClassName = adapterClassName;
            return this;
        }

        public Builder setMapadapterclassname(GemValue<String> mapAdapterClassName ) {
            this.mapAdapterClassName = mapAdapterClassName;
            return this;
        }

        public Builder setAutoconfigpackage(GemValue<String> autoConfigPackage ) {
            this.autoConfigPackage = autoConfigPackage;
            return this;
        }

        public Builder setAutomapperconfigclassname(GemValue<String> autoMapperConfigClassName ) {
            this.autoMapperConfigClassName = autoMapperConfigClassName;
            return this;
        }

        public Builder setAutomapmapperconfigclassname(GemValue<String> autoMapMapperConfigClassName ) {
            this.autoMapMapperConfigClassName = autoMapMapperConfigClassName;
            return this;
        }

        public Builder  setMirror( AnnotationMirror mirror ) {
            this.mirror = mirror;
            return this;
        }

        public MapperConfigGem build() {
            return new MapperConfigGem( this );
        }
    }

}
