/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.metadata;

import com.squareup.javapoet.ClassName;
import io.github.linpeilie.processor.metadata.AbstractMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMappingMetadata;
import io.github.linpeilie.processor.utils.MapperUtils;
import io.github.linpeilie.utils.StrUtil;
import java.util.List;
import org.mapstruct.NullValueMappingStrategy;
import org.mapstruct.SubclassExhaustiveStrategy;

public class AutoMapperMetadata
extends AbstractMapperMetadata {
    private String mapperName;
    private String mapperNameSuffix;
    private ClassName targetClassName;
    private List<ClassName> usesClassNameList;
    private List<ClassName> useEnumClassNameList;
    private List<ClassName> importsClassNameList;
    private List<AutoMappingMetadata> fieldMappingList;
    private List<AutoMappingMetadata> fieldReverseMappingList;
    private ClassName superClass;
    private ClassName[] superGenerics;
    private ClassName mapstructConfigClass;
    private boolean convertGenerate;
    private boolean reverseConvertGenerate;
    private boolean cycleAvoiding;
    private String unmappedSourcePolicy;
    private String unmappedTargetPolicy;
    private String typeConversionPolicy;
    private String collectionMappingStrategy;
    private String nullValueMappingStrategy;
    private String nullValueIterableMappingStrategy;
    private NullValueMappingStrategy nullValueMapMappingStrategy;
    private String nullValuePropertyMappingStrategy;
    private String nullValueCheckStrategy;
    private SubclassExhaustiveStrategy subclassExhaustiveStrategy;
    private ClassName mappingControl;

    public AutoMapperMetadata(ClassName sourceClassName, ClassName targetClassName) {
        this.sourceClassName = sourceClassName;
        this.targetClassName = targetClassName;
        this.mapperName = MapperUtils.getMapperClassName(sourceClassName.reflectionName(), targetClassName.reflectionName());
    }

    public String qualifiedMapperName() {
        return this.mapperPackage() + "." + this.mapperName();
    }

    @Override
    public String mapperName() {
        return StrUtil.isNotEmpty((CharSequence)this.mapperNameSuffix) ? this.mapperName + this.mapperNameSuffix : this.mapperName;
    }

    public void setMapperName(String mapperName) {
        this.mapperName = mapperName;
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public String getMapperNameSuffix() {
        return this.mapperNameSuffix;
    }

    public void setMapperNameSuffix(String mapperNameSuffix) {
        this.mapperNameSuffix = mapperNameSuffix;
    }

    public ClassName getTargetClassName() {
        return this.targetClassName;
    }

    public AutoMapperMetadata setTargetClassName(ClassName targetClassName) {
        this.targetClassName = targetClassName;
        return this;
    }

    public List<ClassName> getUsesClassNameList() {
        return this.usesClassNameList;
    }

    public AutoMapperMetadata setUsesClassNameList(List<ClassName> usesClassNameList) {
        this.usesClassNameList = usesClassNameList;
        return this;
    }

    public List<ClassName> getUseEnumClassNameList() {
        return this.useEnumClassNameList;
    }

    public void setUseEnumClassNameList(List<ClassName> useEnumClassNameList) {
        this.useEnumClassNameList = useEnumClassNameList;
    }

    public List<ClassName> getImportsClassNameList() {
        return this.importsClassNameList;
    }

    public void setImportsClassNameList(List<ClassName> importsClassNameList) {
        this.importsClassNameList = importsClassNameList;
    }

    public List<AutoMappingMetadata> getFieldMappingList() {
        return this.fieldMappingList;
    }

    public AutoMapperMetadata setFieldMappingList(List<AutoMappingMetadata> fieldMappingList) {
        this.fieldMappingList = fieldMappingList;
        return this;
    }

    public ClassName getSuperClass() {
        return this.superClass;
    }

    public ClassName[] getSuperGenerics() {
        return this.superGenerics;
    }

    public void setSuperGenerics(ClassName[] superGenerics) {
        this.superGenerics = superGenerics;
    }

    public void setSuperClass(ClassName superClass) {
        this.superClass = superClass;
    }

    public ClassName getMapstructConfigClass() {
        return this.mapstructConfigClass;
    }

    public void setMapstructConfigClass(ClassName mapstructConfigClass) {
        this.mapstructConfigClass = mapstructConfigClass;
    }

    public boolean isReverseConvertGenerate() {
        return this.reverseConvertGenerate;
    }

    public void setReverseConvertGenerate(boolean reverseConvertGenerate) {
        this.reverseConvertGenerate = reverseConvertGenerate;
    }

    public List<AutoMappingMetadata> getFieldReverseMappingList() {
        return this.fieldReverseMappingList;
    }

    public void setFieldReverseMappingList(List<AutoMappingMetadata> fieldReverseMappingList) {
        this.fieldReverseMappingList = fieldReverseMappingList;
    }

    public boolean isConvertGenerate() {
        return this.convertGenerate;
    }

    public void setConvertGenerate(boolean convertGenerate) {
        this.convertGenerate = convertGenerate;
    }

    public boolean isCycleAvoiding() {
        return this.cycleAvoiding;
    }

    public void setCycleAvoiding(boolean cycleAvoiding) {
        this.cycleAvoiding = cycleAvoiding;
    }

    public String getUnmappedSourcePolicy() {
        return this.unmappedSourcePolicy;
    }

    public void setUnmappedSourcePolicy(String unmappedSourcePolicy) {
        this.unmappedSourcePolicy = unmappedSourcePolicy;
    }

    public String getUnmappedTargetPolicy() {
        return this.unmappedTargetPolicy;
    }

    public void setUnmappedTargetPolicy(String unmappedTargetPolicy) {
        this.unmappedTargetPolicy = unmappedTargetPolicy;
    }

    public String getTypeConversionPolicy() {
        return this.typeConversionPolicy;
    }

    public void setTypeConversionPolicy(String typeConversionPolicy) {
        this.typeConversionPolicy = typeConversionPolicy;
    }

    public String getCollectionMappingStrategy() {
        return this.collectionMappingStrategy;
    }

    public void setCollectionMappingStrategy(String collectionMappingStrategy) {
        this.collectionMappingStrategy = collectionMappingStrategy;
    }

    public String getNullValueMappingStrategy() {
        return this.nullValueMappingStrategy;
    }

    public void setNullValueMappingStrategy(String nullValueMappingStrategy) {
        this.nullValueMappingStrategy = nullValueMappingStrategy;
    }

    public String getNullValueIterableMappingStrategy() {
        return this.nullValueIterableMappingStrategy;
    }

    public void setNullValueIterableMappingStrategy(String nullValueIterableMappingStrategy) {
        this.nullValueIterableMappingStrategy = nullValueIterableMappingStrategy;
    }

    public NullValueMappingStrategy getNullValueMapMappingStrategy() {
        return this.nullValueMapMappingStrategy;
    }

    public void setNullValueMapMappingStrategy(NullValueMappingStrategy nullValueMapMappingStrategy) {
        this.nullValueMapMappingStrategy = nullValueMapMappingStrategy;
    }

    public String getNullValuePropertyMappingStrategy() {
        return this.nullValuePropertyMappingStrategy;
    }

    public void setNullValuePropertyMappingStrategy(String nullValuePropertyMappingStrategy) {
        this.nullValuePropertyMappingStrategy = nullValuePropertyMappingStrategy;
    }

    public String getNullValueCheckStrategy() {
        return this.nullValueCheckStrategy;
    }

    public void setNullValueCheckStrategy(String nullValueCheckStrategy) {
        this.nullValueCheckStrategy = nullValueCheckStrategy;
    }

    public SubclassExhaustiveStrategy getSubclassExhaustiveStrategy() {
        return this.subclassExhaustiveStrategy;
    }

    public void setSubclassExhaustiveStrategy(SubclassExhaustiveStrategy subclassExhaustiveStrategy) {
        this.subclassExhaustiveStrategy = subclassExhaustiveStrategy;
    }

    public ClassName getMappingControl() {
        return this.mappingControl;
    }

    public void setMappingControl(ClassName mappingControl) {
        this.mappingControl = mappingControl;
    }
}

