package io.github.linpeilie.processor.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.tools.gem.Gem;
import org.mapstruct.tools.gem.GemValue;

import javax.lang.model.type.TypeMirror;

public class ReverseAutoMappingGem implements Gem {

    private final GemValue<TypeMirror> targetClass;
    private final GemValue<String> source;
    private final GemValue<String> target;
    private final GemValue<String> dateFormat;
    private final GemValue<String> numberFormat;
    private final GemValue<String> constant;
    private final GemValue<String> expression;
    private final GemValue<String> defaultExpression;
    private final GemValue<String> conditionExpression;
    private final GemValue<Boolean> ignore;
    private final GemValue<String> defaultValue;
    private final GemValue<List<TypeMirror>> qualifiedBy;
    private final GemValue<List<String>> qualifiedByName;
    private final GemValue<List<String>> conditionQualifiedByName;
    private final GemValue<List<String>> dependsOn;
    private final GemValue<String> nullValueCheckStrategy;
    private final GemValue<String> nullValuePropertyMappingStrategy;
    private final GemValue<TypeMirror> mappingControl;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private ReverseAutoMappingGem( BuilderImpl builder ) {
        this.targetClass = builder.targetClass;
        this.source = builder.source;
        this.target = builder.target;
        this.dateFormat = builder.dateFormat;
        this.numberFormat = builder.numberFormat;
        this.constant = builder.constant;
        this.expression = builder.expression;
        this.defaultExpression = builder.defaultExpression;
        this.conditionExpression = builder.conditionExpression;
        this.ignore = builder.ignore;
        this.defaultValue = builder.defaultValue;
        this.qualifiedBy = builder.qualifiedBy;
        this.qualifiedByName = builder.qualifiedByName;
        this.conditionQualifiedByName = builder.conditionQualifiedByName;
        this.dependsOn = builder.dependsOn;
        this.nullValueCheckStrategy = builder.nullValueCheckStrategy;
        this.nullValuePropertyMappingStrategy = builder.nullValuePropertyMappingStrategy;
        this.mappingControl = builder.mappingControl;
        isValid = ( this.targetClass != null ? this.targetClass.isValid() : false )
               && ( this.source != null ? this.source.isValid() : false )
               && ( this.target != null ? this.target.isValid() : false )
               && ( this.dateFormat != null ? this.dateFormat.isValid() : false )
               && ( this.numberFormat != null ? this.numberFormat.isValid() : false )
               && ( this.constant != null ? this.constant.isValid() : false )
               && ( this.expression != null ? this.expression.isValid() : false )
               && ( this.defaultExpression != null ? this.defaultExpression.isValid() : false )
               && ( this.conditionExpression != null ? this.conditionExpression.isValid() : false )
               && ( this.ignore != null ? this.ignore.isValid() : false )
               && ( this.defaultValue != null ? this.defaultValue.isValid() : false )
               && ( this.qualifiedBy != null ? this.qualifiedBy.isValid() : false )
               && ( this.qualifiedByName != null ? this.qualifiedByName.isValid() : false )
               && ( this.conditionQualifiedByName != null ? this.conditionQualifiedByName.isValid() : false )
               && ( this.dependsOn != null ? this.dependsOn.isValid() : false )
               && ( this.nullValueCheckStrategy != null ? this.nullValueCheckStrategy.isValid() : false )
               && ( this.nullValuePropertyMappingStrategy != null ? this.nullValuePropertyMappingStrategy.isValid() : false )
               && ( this.mappingControl != null ? this.mappingControl.isValid() : false );
        mirror = builder.mirror;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#targetClass}
    */
    public GemValue<TypeMirror> targetClass( ) {
        return targetClass;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#source}
    */
    public GemValue<String> source( ) {
        return source;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#target}
    */
    public GemValue<String> target( ) {
        return target;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#dateFormat}
    */
    public GemValue<String> dateFormat( ) {
        return dateFormat;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#numberFormat}
    */
    public GemValue<String> numberFormat( ) {
        return numberFormat;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#constant}
    */
    public GemValue<String> constant( ) {
        return constant;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#expression}
    */
    public GemValue<String> expression( ) {
        return expression;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#defaultExpression}
    */
    public GemValue<String> defaultExpression( ) {
        return defaultExpression;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#conditionExpression}
    */
    public GemValue<String> conditionExpression( ) {
        return conditionExpression;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#ignore}
    */
    public GemValue<Boolean> ignore( ) {
        return ignore;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#defaultValue}
    */
    public GemValue<String> defaultValue( ) {
        return defaultValue;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#qualifiedBy}
    */
    public GemValue<List<TypeMirror>> qualifiedBy( ) {
        return qualifiedBy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#qualifiedByName}
    */
    public GemValue<List<String>> qualifiedByName( ) {
        return qualifiedByName;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#conditionQualifiedByName}
    */
    public GemValue<List<String>> conditionQualifiedByName( ) {
        return conditionQualifiedByName;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#dependsOn}
    */
    public GemValue<List<String>> dependsOn( ) {
        return dependsOn;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#nullValueCheckStrategy}
    */
    public GemValue<String> nullValueCheckStrategy( ) {
        return nullValueCheckStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#nullValuePropertyMappingStrategy}
    */
    public GemValue<String> nullValuePropertyMappingStrategy( ) {
        return nullValuePropertyMappingStrategy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link ReverseAutoMappingGem#mappingControl}
    */
    public GemValue<TypeMirror> mappingControl( ) {
        return mappingControl;
    }

    @Override
    public AnnotationMirror mirror( ) {
        return mirror;
    }

    @Override
    public boolean isValid( ) {
        return isValid;
    }

    public static ReverseAutoMappingGem  instanceOn(Element element) {
        return build( element, new BuilderImpl() );
    }

    public static ReverseAutoMappingGem instanceOn(AnnotationMirror mirror ) {
        return build( mirror, new BuilderImpl() );
    }

    public static  <T> T  build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream()
            .filter( a ->  "io.github.linpeilie.annotations.ReverseAutoMapping".contentEquals( ( ( TypeElement )a.getAnnotationType().asElement() ).getQualifiedName() ) )
            .findAny()
            .orElse( null );
        return build( mirror, builder );
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder ) {

        // return fast
        if ( mirror == null || builder == null ) {
            return null;
        }

        // fetch defaults from all defined values in the annotation type
        List<ExecutableElement> enclosed = ElementFilter.methodsIn( mirror.getAnnotationType().asElement().getEnclosedElements() );
        Map<String, AnnotationValue> defaultValues = new HashMap<>( enclosed.size() );
        enclosed.forEach( e -> defaultValues.put( e.getSimpleName().toString(), e.getDefaultValue() ) );

        // fetch all explicitely set annotation values in the annotation instance
        Map<String, AnnotationValue> values = new HashMap<>( enclosed.size() );
        mirror.getElementValues().entrySet().forEach( e -> values.put( e.getKey().getSimpleName().toString(), e.getValue() ) );

        // iterate and populate builder
        for ( String methodName : defaultValues.keySet() ) {

            if ( "targetClass".equals( methodName ) ) {
                builder.setTargetclass( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "source".equals( methodName ) ) {
                builder.setSource( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "target".equals( methodName ) ) {
                builder.setTarget( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "dateFormat".equals( methodName ) ) {
                builder.setDateformat( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "numberFormat".equals( methodName ) ) {
                builder.setNumberformat( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "constant".equals( methodName ) ) {
                builder.setConstant( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "expression".equals( methodName ) ) {
                builder.setExpression( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "defaultExpression".equals( methodName ) ) {
                builder.setDefaultexpression( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "conditionExpression".equals( methodName ) ) {
                builder.setConditionexpression( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "ignore".equals( methodName ) ) {
                builder.setIgnore( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), Boolean.class ) );
            }
            else if ( "defaultValue".equals( methodName ) ) {
                builder.setDefaultvalue( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "qualifiedBy".equals( methodName ) ) {
                builder.setQualifiedby( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "qualifiedByName".equals( methodName ) ) {
                builder.setQualifiedbyname( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "conditionQualifiedByName".equals( methodName ) ) {
                builder.setConditionqualifiedbyname( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "dependsOn".equals( methodName ) ) {
                builder.setDependson( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
            else if ( "nullValueCheckStrategy".equals( methodName ) ) {
                builder.setNullvaluecheckstrategy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "nullValuePropertyMappingStrategy".equals( methodName ) ) {
                builder.setNullvaluepropertymappingstrategy( GemValue.createEnum( values.get( methodName ), defaultValues.get( methodName ) ) );
            }
            else if ( "mappingControl".equals( methodName ) ) {
                builder.setMappingcontrol( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
        }
        builder.setMirror( mirror );
        return builder.build();
    }

    /**
     * A builder that can be implemented by the user to define custom logic e.g. in the
     * build method, prior to creating the annotation gem.
     */
    public interface Builder<T> {

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#targetClass}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setTargetclass(GemValue<TypeMirror> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#source}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setSource(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#target}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setTarget(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#dateFormat}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setDateformat(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#numberFormat}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setNumberformat(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#constant}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setConstant(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#expression}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setExpression(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#defaultExpression}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setDefaultexpression(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#conditionExpression}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setConditionexpression(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#ignore}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setIgnore(GemValue<Boolean> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#defaultValue}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setDefaultvalue(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#qualifiedBy}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setQualifiedby(GemValue<List<TypeMirror>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#qualifiedByName}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setQualifiedbyname(GemValue<List<String>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#conditionQualifiedByName}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setConditionqualifiedbyname(GemValue<List<String>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#dependsOn}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setDependson(GemValue<List<String>> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#nullValueCheckStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setNullvaluecheckstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#nullValuePropertyMappingStrategy}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setNullvaluepropertymappingstrategy(GemValue<String> methodName );

       /**
        * Sets the {@link GemValue} for {@link ReverseAutoMappingGem#mappingControl}
        *
        * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
        */
        Builder setMappingcontrol(GemValue<TypeMirror> methodName );

        /**
         * Sets the annotation mirror
         *
         * @param mirror the mirror which this gem represents
         *
         * @return the {@link Builder} for this gem, representing {@link ReverseAutoMappingGem}
         */
          Builder setMirror( AnnotationMirror mirror );

        /**
         * The build method can be overriden in a custom custom implementation, which allows
         * the user to define his own custom validation on the annotation.
         *
         * @return the representation of the annotation
         */
        T build();
    }

    private static class BuilderImpl implements Builder<ReverseAutoMappingGem> {

        private GemValue<TypeMirror> targetClass;
        private GemValue<String> source;
        private GemValue<String> target;
        private GemValue<String> dateFormat;
        private GemValue<String> numberFormat;
        private GemValue<String> constant;
        private GemValue<String> expression;
        private GemValue<String> defaultExpression;
        private GemValue<String> conditionExpression;
        private GemValue<Boolean> ignore;
        private GemValue<String> defaultValue;
        private GemValue<List<TypeMirror>> qualifiedBy;
        private GemValue<List<String>> qualifiedByName;
        private GemValue<List<String>> conditionQualifiedByName;
        private GemValue<List<String>> dependsOn;
        private GemValue<String> nullValueCheckStrategy;
        private GemValue<String> nullValuePropertyMappingStrategy;
        private GemValue<TypeMirror> mappingControl;
        private AnnotationMirror mirror;

        public Builder setTargetclass(GemValue<TypeMirror> targetClass ) {
            this.targetClass = targetClass;
            return this;
        }

        public Builder setSource(GemValue<String> source ) {
            this.source = source;
            return this;
        }

        public Builder setTarget(GemValue<String> target ) {
            this.target = target;
            return this;
        }

        public Builder setDateformat(GemValue<String> dateFormat ) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder setNumberformat(GemValue<String> numberFormat ) {
            this.numberFormat = numberFormat;
            return this;
        }

        public Builder setConstant(GemValue<String> constant ) {
            this.constant = constant;
            return this;
        }

        public Builder setExpression(GemValue<String> expression ) {
            this.expression = expression;
            return this;
        }

        public Builder setDefaultexpression(GemValue<String> defaultExpression ) {
            this.defaultExpression = defaultExpression;
            return this;
        }

        public Builder setConditionexpression(GemValue<String> conditionExpression ) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public Builder setIgnore(GemValue<Boolean> ignore ) {
            this.ignore = ignore;
            return this;
        }

        public Builder setDefaultvalue(GemValue<String> defaultValue ) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setQualifiedby(GemValue<List<TypeMirror>> qualifiedBy ) {
            this.qualifiedBy = qualifiedBy;
            return this;
        }

        public Builder setQualifiedbyname(GemValue<List<String>> qualifiedByName ) {
            this.qualifiedByName = qualifiedByName;
            return this;
        }

        public Builder setConditionqualifiedbyname(GemValue<List<String>> conditionQualifiedByName ) {
            this.conditionQualifiedByName = conditionQualifiedByName;
            return this;
        }

        public Builder setDependson(GemValue<List<String>> dependsOn ) {
            this.dependsOn = dependsOn;
            return this;
        }

        public Builder setNullvaluecheckstrategy(GemValue<String> nullValueCheckStrategy ) {
            this.nullValueCheckStrategy = nullValueCheckStrategy;
            return this;
        }

        public Builder setNullvaluepropertymappingstrategy(GemValue<String> nullValuePropertyMappingStrategy ) {
            this.nullValuePropertyMappingStrategy = nullValuePropertyMappingStrategy;
            return this;
        }

        public Builder setMappingcontrol(GemValue<TypeMirror> mappingControl ) {
            this.mappingControl = mappingControl;
            return this;
        }

        public Builder  setMirror( AnnotationMirror mirror ) {
            this.mirror = mirror;
            return this;
        }

        public ReverseAutoMappingGem build() {
            return new ReverseAutoMappingGem( this );
        }
    }

}
