/*
 * Decompiled with CFR 0.152.
 */
package io.github.mainstringargs.alpaca.rest.orders;

import io.github.mainstringargs.alpaca.Utilities;
import io.github.mainstringargs.alpaca.enums.OrderSide;
import io.github.mainstringargs.alpaca.enums.OrderTimeInForce;
import io.github.mainstringargs.alpaca.enums.OrderType;
import io.github.mainstringargs.alpaca.rest.orders.OrdersRequestBuilder;

public class PostOrderRequestBuilder
extends OrdersRequestBuilder {
    public PostOrderRequestBuilder(String baseUrl) {
        super(baseUrl);
    }

    public PostOrderRequestBuilder symbol(String symbol) {
        if (symbol != null) {
            super.appendBodyProperty("symbol", symbol);
        }
        return this;
    }

    public PostOrderRequestBuilder quantity(Integer qty) {
        if (qty != null) {
            super.appendBodyProperty("qty", qty.toString());
        }
        return this;
    }

    public PostOrderRequestBuilder side(OrderSide side) {
        if (side != null) {
            super.appendBodyProperty("side", side.getAPIName());
        }
        return this;
    }

    public PostOrderRequestBuilder type(OrderType type) {
        if (type != null) {
            super.appendBodyProperty("type", type.getAPIName());
        }
        return this;
    }

    public PostOrderRequestBuilder timeInForce(OrderTimeInForce tif) {
        if (tif != null) {
            super.appendBodyProperty("time_in_force", tif.getAPIName());
        }
        return this;
    }

    public PostOrderRequestBuilder limitPrice(Number limitPrice) {
        if (limitPrice != null) {
            super.appendBodyProperty("limit_price", Utilities.toDecimalFormat(limitPrice));
        }
        return this;
    }

    public PostOrderRequestBuilder stopPrice(Number stopPrice) {
        if (stopPrice != null) {
            super.appendBodyProperty("stop_price", Utilities.toDecimalFormat(stopPrice));
        }
        return this;
    }

    public PostOrderRequestBuilder clientOrderId(String clientOrderId) {
        if (clientOrderId != null) {
            super.appendBodyProperty("client_order_id", clientOrderId);
        }
        return this;
    }
}

