/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock.util;

import io.github.md2java.lock.annotation.EnableClusterLock;
import io.github.md2java.lock.model.LockInfo;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryUtil {
    private static EnableClusterLock enableClusterLock = null;
    private static Map<String, LockInfo> data = new ConcurrentHashMap<String, LockInfo>();

    public static LockInfo getLockInfo(String name) {
        return data.get(name);
    }

    public static void updateLockInfo(String name, LockInfo info) {
        data.put(name, info);
    }

    public static void updateLockInfo(String name, Map<String, Object> info) {
        LockInfo lockInfo = data.get(name);
        if (Objects.isNull(lockInfo)) {
            lockInfo = LockInfo.builder().lockname(name).build();
        }
        lockInfo.setActiveNode(String.valueOf(info.get("activenode")));
        Date lastRun = (Date)info.get("lastrun");
        lockInfo.setLastrun(lastRun);
        Date lastnodeRun = (Date)info.get("lastnoderun");
        lockInfo.setLastnoderun(lastnodeRun);
        data.put(name, lockInfo);
    }

    public static EnableClusterLock getEnableClusterLock() {
        return enableClusterLock;
    }

    public static void setEnableClusterLock(EnableClusterLock enableClusterLock) {
        MemoryUtil.enableClusterLock = enableClusterLock;
    }
}

