/*
 * Decompiled with CFR 0.152.
 */
package RenderMultipoints;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.RendererException;
import JavaLineArray.POINT2;
import JavaLineArray.Shape2;
import JavaTacticalRenderer.TGLight;
import JavaTacticalRenderer.clsUtility;
import RenderMultipoints.clsUtilityCPOF;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;

public final class clsClipPolygon2 {
    private static final String _className = "clsClipPolygon2";

    private static Point2D intersectPoint(Point2D pt0, Point2D pt1, Line2D currentEdge) {
        Point2D.Double ptIntersect = null;
        try {
            Point2D edgePt1 = currentEdge.getP1();
            Point2D edgePt2 = currentEdge.getP2();
            double edge_x = 0.0;
            double edge_y = 0.0;
            double m = 0.0;
            double deltaX = 0.0;
            double deltaY = 0.0;
            if (Math.abs(edgePt1.getX() - edgePt2.getX()) < Math.abs(edgePt1.getY() - edgePt2.getY())) {
                ptIntersect = new Point2D.Double();
                edge_x = edgePt1.getX();
                if (Math.abs(pt1.getX() - pt0.getX()) < 1.0) {
                    pt1.setLocation(pt1.getX() + 1.0, pt1.getY());
                }
                m = (pt1.getY() - pt0.getY()) / (pt1.getX() - pt0.getX());
                deltaX = edge_x - pt0.getX();
                ((Point2D)ptIntersect).setLocation(edge_x, pt0.getY() + m * deltaX);
            } else {
                ptIntersect = new Point2D.Double();
                edge_y = edgePt1.getY();
                if (Math.abs(pt1.getX() - pt0.getX()) < 1.0) {
                    pt1.setLocation(pt1.getX() + 1.0, pt1.getY());
                }
                m = (pt1.getY() - pt0.getY()) / (pt1.getX() - pt0.getX());
                deltaY = edge_y - pt0.getY();
                ((Point2D)ptIntersect).setLocation(pt0.getX() + deltaY / m, edge_y);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"intersectPoint", (Exception)new RendererException("Failed inside intersectPoint", (Throwable)exc));
        }
        return ptIntersect;
    }

    private static ArrayList<Point2D> clipTop(TGLight tg, ArrayList<Point2D> pts, Rectangle2D clipBounds) {
        ArrayList<Point2D> ptsResult = new ArrayList<Point2D>();
        try {
            double ulx = 0.0;
            double uly = 0.0;
            double lrx = 0.0;
            ulx = clipBounds.getMinX();
            uly = clipBounds.getMinY();
            Point2D.Double ul = new Point2D.Double(ulx, uly);
            Point2D.Double ur = new Point2D.Double(lrx, uly);
            int j = 0;
            Point2D current = null;
            Point2D previous = null;
            Point2D intersectPt = null;
            for (j = 0; j < pts.size(); ++j) {
                Line2D.Double edge;
                current = pts.get(j);
                previous = j == 0 ? pts.get(pts.size() - 1) : pts.get(j - 1);
                if (previous.getY() >= ((Point2D)ul).getY() && current.getY() >= ((Point2D)ul).getY()) {
                    ptsResult.add(current);
                }
                if (previous.getY() >= ((Point2D)ul).getY() && current.getY() < ((Point2D)ul).getY()) {
                    edge = new Line2D.Double(ul, ur);
                    intersectPt = clsClipPolygon2.intersectPoint(previous, current, edge);
                    if (intersectPt != null) {
                        ptsResult.add(intersectPt);
                    }
                    tg.set_WasClipped(true);
                }
                if (previous.getY() < ((Point2D)ul).getY() && current.getY() < ((Point2D)ul).getY() || !(previous.getY() < ((Point2D)ul).getY()) || !(current.getY() >= ((Point2D)ul).getY())) continue;
                edge = new Line2D.Double(ul, ur);
                intersectPt = clsClipPolygon2.intersectPoint(previous, current, edge);
                if (intersectPt != null) {
                    ptsResult.add(intersectPt);
                }
                ptsResult.add(current);
                tg.set_WasClipped(true);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"clipTop", (Exception)new RendererException("Failed inside clipTop", (Throwable)exc));
        }
        return ptsResult;
    }

    private static ArrayList<Point2D> clipBottom(TGLight tg, ArrayList<Point2D> pts, Rectangle2D clipBounds) {
        ArrayList<Point2D> ptsResult = new ArrayList<Point2D>();
        try {
            double ulx = 0.0;
            double uly = 0.0;
            double lrx = 0.0;
            double lry = 0.0;
            ulx = clipBounds.getMinX();
            lrx = clipBounds.getMaxX();
            lry = clipBounds.getMaxY();
            Point2D.Double ll = new Point2D.Double(ulx, lry);
            Point2D.Double lr = new Point2D.Double(lrx, lry);
            int j = 0;
            Point2D current = null;
            Point2D previous = null;
            Point2D intersectPt = null;
            for (j = 0; j < pts.size(); ++j) {
                Line2D.Double edge;
                current = pts.get(j);
                previous = j == 0 ? pts.get(pts.size() - 1) : pts.get(j - 1);
                if (previous.getY() <= ((Point2D)lr).getY() && current.getY() <= ((Point2D)lr).getY()) {
                    ptsResult.add(current);
                }
                if (previous.getY() <= ((Point2D)lr).getY() && current.getY() > ((Point2D)lr).getY()) {
                    edge = new Line2D.Double(ll, lr);
                    intersectPt = clsClipPolygon2.intersectPoint(previous, current, edge);
                    if (intersectPt != null) {
                        ptsResult.add(intersectPt);
                    }
                    tg.set_WasClipped(true);
                }
                if (previous.getY() > ((Point2D)lr).getY() && current.getY() > ((Point2D)lr).getY() || !(previous.getY() > ((Point2D)lr).getY()) || !(current.getY() <= ((Point2D)lr).getY())) continue;
                edge = new Line2D.Double(ll, lr);
                intersectPt = clsClipPolygon2.intersectPoint(previous, current, edge);
                if (intersectPt != null) {
                    ptsResult.add(intersectPt);
                }
                ptsResult.add(current);
                tg.set_WasClipped(true);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"clipBottom", (Exception)new RendererException("Failed inside clipBottom", (Throwable)exc));
        }
        return ptsResult;
    }

    private static ArrayList<Point2D> clipRight(TGLight tg, ArrayList<Point2D> pts, Rectangle2D clipBounds) {
        ArrayList<Point2D> ptsResult = new ArrayList<Point2D>();
        try {
            double uly = 0.0;
            double lrx = 0.0;
            double lry = 0.0;
            uly = clipBounds.getMinY();
            lrx = clipBounds.getMaxX();
            lry = clipBounds.getMaxY();
            Point2D.Double ur = new Point2D.Double(lrx, uly);
            Point2D.Double lr = new Point2D.Double(lrx, lry);
            int j = 0;
            Point2D current = null;
            Point2D previous = null;
            Point2D intersectPt = null;
            for (j = 0; j < pts.size(); ++j) {
                Line2D.Double edge;
                current = pts.get(j);
                previous = j == 0 ? pts.get(pts.size() - 1) : pts.get(j - 1);
                if (previous.getX() <= ((Point2D)lr).getX() && current.getX() <= ((Point2D)lr).getX()) {
                    ptsResult.add(current);
                }
                if (previous.getX() <= ((Point2D)lr).getX() && current.getX() > ((Point2D)lr).getX()) {
                    edge = new Line2D.Double(ur, lr);
                    intersectPt = clsClipPolygon2.intersectPoint(previous, current, edge);
                    if (intersectPt != null) {
                        ptsResult.add(intersectPt);
                    }
                    tg.set_WasClipped(true);
                }
                if (previous.getX() > ((Point2D)lr).getX() && current.getX() > ((Point2D)lr).getX() || !(previous.getX() > ((Point2D)lr).getX()) || !(current.getX() <= ((Point2D)lr).getX())) continue;
                edge = new Line2D.Double(ur, lr);
                intersectPt = clsClipPolygon2.intersectPoint(previous, current, edge);
                if (intersectPt != null) {
                    ptsResult.add(intersectPt);
                }
                ptsResult.add(current);
                tg.set_WasClipped(true);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"clipRight", (Exception)new RendererException("Failed inside clipRight", (Throwable)exc));
        }
        return ptsResult;
    }

    private static ArrayList<Point2D> clipLeft(TGLight tg, ArrayList<Point2D> pts, Rectangle2D clipBounds) {
        ArrayList<Point2D> ptsResult = new ArrayList<Point2D>();
        try {
            double ulx = 0.0;
            double uly = 0.0;
            double lry = 0.0;
            ulx = clipBounds.getMinX();
            uly = clipBounds.getMinY();
            lry = clipBounds.getMaxY();
            Point2D.Double ul = new Point2D.Double(ulx, uly);
            Point2D.Double ll = new Point2D.Double(ulx, lry);
            int j = 0;
            Point2D current = null;
            Point2D previous = null;
            Point2D intersectPt = null;
            for (j = 0; j < pts.size(); ++j) {
                Line2D.Double edge;
                current = pts.get(j);
                previous = j == 0 ? pts.get(pts.size() - 1) : pts.get(j - 1);
                if (previous.getX() >= ((Point2D)ll).getX() && current.getX() >= ((Point2D)ll).getX()) {
                    ptsResult.add(current);
                }
                if (previous.getX() >= ((Point2D)ll).getX() && current.getX() < ((Point2D)ll).getX()) {
                    edge = new Line2D.Double(ul, ll);
                    intersectPt = clsClipPolygon2.intersectPoint(previous, current, edge);
                    if (intersectPt != null) {
                        ptsResult.add(intersectPt);
                    }
                    tg.set_WasClipped(true);
                }
                if (previous.getX() < ((Point2D)ll).getX() && current.getX() < ((Point2D)ll).getX() || !(previous.getX() < ((Point2D)ll).getX()) || !(current.getX() >= ((Point2D)ll).getX())) continue;
                edge = new Line2D.Double(ul, ll);
                intersectPt = clsClipPolygon2.intersectPoint(previous, current, edge);
                if (intersectPt != null) {
                    ptsResult.add(intersectPt);
                }
                ptsResult.add(current);
                tg.set_WasClipped(true);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"clipLeft", (Exception)new RendererException("Failed inside clipLeft", (Throwable)exc));
        }
        return ptsResult;
    }

    private static int AddBoundaryPointsForLines(ArrayList<Point2D> polygon, Rectangle2D clipBounds) {
        int result = 0;
        try {
            double ulx = 0.0;
            double uly = 0.0;
            double lrx = 0.0;
            double lry = 0.0;
            ulx = clipBounds.getMinX();
            uly = clipBounds.getMinY();
            lrx = clipBounds.getMaxX();
            lry = clipBounds.getMaxY();
            Point2D.Double ul = new Point2D.Double(ulx + 10.0, uly + 10.0);
            Point2D.Double ur = new Point2D.Double(lrx - 10.0, uly + 10.0);
            Point2D.Double ll = new Point2D.Double(ulx + 10.0, lry - 10.0);
            Point2D.Double lr = new Point2D.Double(lrx - 10.0, lry - 10.0);
            Point2D pt0 = polygon.get(0);
            Point2D ptn = polygon.get(polygon.size() - 1);
            Boolean addToFront = false;
            Boolean addToEnd = false;
            if (pt0.getY() < uly) {
                polygon.add(0, ul);
                addToFront = true;
            } else if (pt0.getX() < ulx) {
                polygon.add(0, ul);
                addToFront = true;
            } else if (pt0.getX() > lrx) {
                polygon.add(0, lr);
                addToFront = true;
            } else if (pt0.getY() > lry) {
                polygon.add(0, lr);
                addToFront = true;
            }
            if (ptn.getY() < uly) {
                polygon.add(ul);
                addToEnd = true;
            } else if (ptn.getX() < ulx) {
                polygon.add(ul);
                addToEnd = true;
            } else if (ptn.getX() > lrx) {
                polygon.add(lr);
                addToEnd = true;
            } else if (ptn.getY() > lry) {
                polygon.add(lr);
                addToEnd = true;
            }
            if (!addToFront.booleanValue() && !addToEnd.booleanValue()) {
                result = 0;
            }
            if (addToFront.booleanValue() && !addToEnd.booleanValue()) {
                result = 1;
            }
            if (!addToFront.booleanValue() && addToEnd.booleanValue()) {
                result = 2;
            }
            if (addToFront.booleanValue() && addToEnd.booleanValue()) {
                result = 3;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"AddBoundaryPointsForLines", (Exception)new RendererException("Failed inside AddBoundaryPointsForLines", (Throwable)exc));
        }
        return result;
    }

    private static void closeAreaTG(TGLight tg) {
        try {
            if (tg.Pixels == null || tg.Pixels.isEmpty()) {
                return;
            }
            POINT2 pt0 = (POINT2)tg.Pixels.get(0);
            POINT2 ptn = (POINT2)tg.Pixels.get(tg.Pixels.size() - 1);
            if (pt0.x != ptn.x || pt0.y != ptn.y) {
                tg.Pixels.add(pt0);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"closeAreaTG", (Exception)new RendererException("Failed inside closeAreaTG", (Throwable)exc));
        }
    }

    protected static ArrayList<Shape2> fillDMA(TGLight tg, Rectangle2D clipBounds) {
        ArrayList<Shape2> shapes = new ArrayList<Shape2>();
        try {
            switch (tg.get_LineType()) {
                case 22134000: 
                case 22340000: 
                case 22350000: 
                case 22624000: 
                case 23111000: 
                case 23111001: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23131200: 
                case 23132000: 
                case 23350000: {
                    break;
                }
                default: {
                    return shapes;
                }
            }
            Shape2 shape = null;
            int j = 0;
            TGLight tg2 = new TGLight();
            tg2.set_LineType(22131000);
            tg2.Pixels = new ArrayList();
            int n = 0;
            n = tg.Pixels.size();
            for (j = 0; j < n; ++j) {
                tg2.Pixels.add((POINT2)tg.Pixels.get(j));
            }
            clsClipPolygon2.closeAreaTG(tg2);
            if (clipBounds != null) {
                clsClipPolygon2.ClipPolygon(tg2, clipBounds);
            }
            if (tg2.Pixels == null || tg2.Pixels.isEmpty()) {
                return shapes;
            }
            shape = new Shape2(Shape2.SHAPE_TYPE_FILL);
            shape.setFillColor(tg.get_FillColor());
            shape.moveTo((POINT2)tg2.Pixels.get(0));
            for (j = 1; j < tg2.Pixels.size(); ++j) {
                shape.lineTo((POINT2)tg2.Pixels.get(j));
            }
            shapes.add(shape);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"fillDMA", (Exception)new RendererException("Failed inside fillDMA", (Throwable)exc));
        }
        return shapes;
    }

    protected static void addAbatisFill(TGLight tg, ArrayList<Shape2> shapes) {
        try {
            if (tg.Pixels == null || tg.Pixels.size() < 2 || tg.get_FillColor() == null || tg.get_FillColor().getAlpha() < 2 || shapes == null) {
                return;
            }
            int j = 0;
            int n = tg.Pixels.size();
            Shape2 shape = null;
            TGLight tg2 = null;
            switch (tg.get_LineType()) {
                case 23410000: {
                    double dist0 = 0.0;
                    double dist1 = 0.0;
                    double dist2 = 0.0;
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.setFillColor(tg.get_FillColor());
                    if (!(tg.Pixels != null & tg.Pixels.size() >= 300)) break;
                    dist0 = Math.abs(((POINT2)tg.Pixels.get((int)0)).x - ((POINT2)tg.Pixels.get((int)50)).x);
                    dist1 = Math.abs(((POINT2)tg.Pixels.get((int)100)).x - ((POINT2)tg.Pixels.get((int)150)).x);
                    dist2 = Math.abs(((POINT2)tg.Pixels.get((int)200)).x - ((POINT2)tg.Pixels.get((int)250)).x);
                    int start = -1;
                    int end = -1;
                    if (dist0 >= dist1 && dist0 >= dist2) {
                        start = 0;
                        end = 99;
                    } else if (dist1 >= dist0 && dist1 >= dist2) {
                        start = 100;
                        end = 199;
                    } else {
                        start = 200;
                        end = 299;
                    }
                    shape.moveTo((POINT2)tg.Pixels.get(start));
                    for (j = start; j <= end; ++j) {
                        shape.lineTo((POINT2)tg.Pixels.get(j));
                    }
                    break;
                }
                case 23120000: {
                    shape = new Shape2(Shape2.SHAPE_TYPE_POLYLINE);
                    shape.setFillColor(tg.get_FillColor());
                    tg2 = new TGLight();
                    tg2.set_LineType(22131000);
                    tg2.Pixels = new ArrayList();
                    if (tg.Pixels == null || tg.Pixels.size() <= 2) break;
                    tg2.Pixels.add((POINT2)tg.Pixels.get(n - 3));
                    tg2.Pixels.add((POINT2)tg.Pixels.get(n - 2));
                    tg2.Pixels.add((POINT2)tg.Pixels.get(n - 1));
                    tg2.Pixels.add((POINT2)tg.Pixels.get(n - 3));
                    shape.moveTo((POINT2)tg2.Pixels.get(0));
                    for (j = 1; j < tg2.Pixels.size(); ++j) {
                        shape.lineTo((POINT2)tg2.Pixels.get(j));
                    }
                    break;
                }
                default: {
                    return;
                }
            }
            if (shapes != null) {
                shapes.add(0, shape);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"addAbatisFill", (Exception)new RendererException("Failed inside addAbatisFill", (Throwable)exc));
        }
    }

    protected static ArrayList<Shape2> LinesWithFill(TGLight tg, Rectangle2D clipBounds) {
        ArrayList<Shape2> shapes = null;
        try {
            if (tg.get_FillColor() == null || tg.get_FillColor().getAlpha() <= 1 || tg.Pixels == null || tg.Pixels.isEmpty()) {
                return shapes;
            }
            switch (tg.get_LineType()) {
                case 21700000: 
                case 21710000: 
                case 22320000: 
                case 22521100: 
                case 22521200: 
                case 22521300: 
                case 22521410: 
                case 22521420: 
                case 23120000: 
                case 25211000: 
                case 25212000: 
                case 211400000: 
                case 211600000: 
                case 211900000: 
                case 212100000: 
                case 212500000: 
                case 212600000: {
                    return shapes;
                }
                case 24326100: {
                    return null;
                }
                case 22134000: 
                case 22340000: 
                case 22350000: 
                case 22624000: 
                case 23111000: 
                case 23113000: 
                case 23114000: 
                case 23115000: 
                case 23131200: 
                case 23132000: 
                case 23350000: {
                    return clsClipPolygon2.fillDMA(tg, clipBounds);
                }
            }
            if (!clsUtility.LinesWithFill((int)tg.get_LineType())) {
                return shapes;
            }
            shapes = new ArrayList<Shape2>();
            Shape2 shape = null;
            TGLight tg2 = new TGLight();
            tg2.set_LineType(22131000);
            tg2.Pixels = new ArrayList();
            tg2.Pixels.addAll(tg.Pixels);
            clsClipPolygon2.closeAreaTG(tg2);
            if (clipBounds != null) {
                clsClipPolygon2.ClipPolygon(tg2, clipBounds);
            }
            if (tg2.Pixels == null || tg2.Pixels.isEmpty()) {
                return null;
            }
            int j = 0;
            shape = new Shape2(Shape2.SHAPE_TYPE_FILL);
            shape.setFillColor(tg.get_FillColor());
            shape.moveTo((POINT2)tg2.Pixels.get(0));
            for (j = 1; j < tg2.Pixels.size(); ++j) {
                shape.lineTo((POINT2)tg2.Pixels.get(j));
            }
            if (tg.get_FillColor() == null && tg.get_FillColor().getAlpha() <= 1) {
                return null;
            }
            shapes.add(shape);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"LinesWithFill", (Exception)new RendererException("Failed inside LinesWithFill", (Throwable)exc));
        }
        return shapes;
    }

    private static ArrayList<Point2D> buildBox(Rectangle2D clipBounds) {
        ArrayList<Point2D> box = new ArrayList<Point2D>();
        try {
            double ulx = 0.0;
            double uly = 0.0;
            double lrx = 0.0;
            double lry = 0.0;
            ulx = clipBounds.getMinX() - 200.0;
            uly = clipBounds.getMinY() - 200.0;
            lrx = clipBounds.getMaxX() + 200.0;
            lry = clipBounds.getMaxY() + 200.0;
            Point2D.Double lr = new Point2D.Double(ulx, uly);
            Point2D.Double ll = new Point2D.Double(ulx - 10.0, uly);
            Point2D.Double ul = new Point2D.Double(ulx - 10.0, uly - 10.0);
            Point2D.Double ur = new Point2D.Double(ulx, uly - 10.0);
            box.add(lr);
            box.add(ll);
            box.add(ul);
            box.add(ur);
            box.add(lr);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"buildBox", (Exception)new RendererException("Failed inside buildBox", (Throwable)exc));
        }
        return box;
    }

    public static ArrayList<Point2D> ClipPolygon(TGLight tg, Rectangle2D clipBounds) {
        ArrayList<Point2D> poly = new ArrayList<Point2D>();
        try {
            ArrayList<Point2D> polygon = clsUtilityCPOF.POINT2toPoint2D(tg.Pixels);
            Boolean isClosed = clsUtility.isClosedPolygon((int)tg.get_LineType());
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int j = 0;
            for (j = 0; j < polygon.size(); ++j) {
                hashMap.put(Integer.toString(j), polygon.get(j));
            }
            Rectangle2D.Double clipBounds2 = new Rectangle2D.Double(clipBounds.getX() - 50.0, clipBounds.getY() - 50.0, clipBounds.getWidth() + 100.0, clipBounds.getHeight() + 100.0);
            int addedLinePoints = 0;
            if (isClosed.booleanValue()) {
                polygon.remove(polygon.size() - 1);
                isClosed = true;
            } else {
                addedLinePoints = clsClipPolygon2.AddBoundaryPointsForLines(polygon, clipBounds2);
            }
            poly = clsClipPolygon2.clipRight(tg, polygon, clipBounds2);
            poly = clsClipPolygon2.clipTop(tg, poly, clipBounds2);
            poly = clsClipPolygon2.clipLeft(tg, poly, clipBounds2);
            poly = clsClipPolygon2.clipBottom(tg, poly, clipBounds2);
            if (isClosed.booleanValue()) {
                if (poly.size() > 0) {
                    poly.add(poly.get(0));
                }
            } else {
                switch (addedLinePoints) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(0);
                        break;
                    }
                    case 2: {
                        if (poly.size() > 0) {
                            poly.remove(poly.size() - 1);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(poly.size() - 1);
                        break;
                    }
                    case 3: {
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() > 0) {
                            poly.remove(poly.size() - 1);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(poly.size() - 1);
                    }
                }
            }
            tg.Pixels = isClosed.booleanValue() ? (poly.size() > 2 ? clsUtilityCPOF.Point2DtoPOINT2Mapped(poly, hashMap) : new ArrayList()) : (poly.size() > 1 ? clsUtilityCPOF.Point2DtoPOINT2Mapped(poly, hashMap) : new ArrayList());
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ClipPolygon", (Exception)new RendererException("Failed inside ClipPolygon", (Throwable)exc));
        }
        return poly;
    }

    public static ArrayList<Point2D> ClipPolygon2(ArrayList<Point2D> polygon, Rectangle2D clipBounds, Boolean isClosed) {
        ArrayList<Point2D> poly = new ArrayList<Point2D>();
        try {
            int addedLinePoints = 0;
            if (isClosed.booleanValue()) {
                if (polygon.size() > 0) {
                    polygon.remove(polygon.size() - 1);
                }
                isClosed = true;
            } else {
                addedLinePoints = clsClipPolygon2.AddBoundaryPointsForLines(polygon, clipBounds);
            }
            poly = clsClipPolygon2.clipRight(null, polygon, clipBounds);
            poly = clsClipPolygon2.clipTop(null, poly, clipBounds);
            poly = clsClipPolygon2.clipLeft(null, poly, clipBounds);
            poly = clsClipPolygon2.clipBottom(null, poly, clipBounds);
            if (isClosed.booleanValue()) {
                if (poly.size() > 0) {
                    poly.add(poly.get(0));
                }
            } else {
                switch (addedLinePoints) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(0);
                        break;
                    }
                    case 2: {
                        if (poly.size() > 0) {
                            poly.remove(poly.size() - 1);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(poly.size() - 1);
                        break;
                    }
                    case 3: {
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() > 0) {
                            poly.remove(0);
                        }
                        if (poly.size() > 0) {
                            poly.remove(poly.size() - 1);
                        }
                        if (poly.size() <= 0) break;
                        poly.remove(poly.size() - 1);
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"ClipPolygon2", (Exception)new RendererException("Failed inside ClipPolygon2", (Throwable)exc));
        }
        return poly;
    }
}

