/*
 * Decompiled with CFR 0.152.
 */
package com.monmonkeygroup.openapi;

public class Config {
    private static String defaultQuoteUrl = "wss://www.mmkpp.com:56011";
    private static String defaultTradeUrl = "wss://www.mmkpp.com:56010";
    private static String defaultSimulatedQuoteUrl = "wss://www.mmktt.com:56011";
    private static String defaultSimulatedTradeUrl = "wss://www.mmktt.com:56010";
    private String user;
    private String quoteAccessToken;
    private String tradeAccessToken;
    private boolean useSimulateEnv;
    private String tradeUrl;
    private String quoteUrl;

    public String getUser() {
        return this.user;
    }

    public String getQuoteAccessToken() {
        return this.quoteAccessToken;
    }

    public String getTradeAccessToken() {
        return this.tradeAccessToken;
    }

    public boolean getUseSimulateEnv() {
        return this.useSimulateEnv;
    }

    public String getTradeUrl() {
        return this.tradeUrl;
    }

    public String getQuoteUrl() {
        return this.quoteUrl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFormEnv() {
        Builder builder = new Builder();
        builder.setUser_(System.getenv("MMK_USER"));
        builder.setQuoteAccessToken(System.getenv("MMK_QUOTE_ACCESS_TOKEN"));
        builder.setTradeAccessToken(System.getenv("MMK_TRADE_ACCESS_TOKEN"));
        builder.setUseSimulateEnv(Boolean.parseBoolean(System.getenv("MMK_USE_SIMULATE_ENV")));
        builder.setQuoteUrl(System.getenv("MMK_QUOTE_URL"));
        builder.setTradeUrl(System.getenv("MMK_TRADE_URL"));
        return builder;
    }

    public static final class Builder {
        private String user_;
        private String quoteAccessToken_;
        private String tradeAccessToken_;
        private boolean useSimulateEnv_;
        private String tradeUrl_;
        private String quoteUrl_;

        private Builder() {
        }

        public Config build() {
            if (null == this.user_ || this.user_.isEmpty()) {
                throw new RuntimeException("don't has user. please set user");
            }
            if (null == this.quoteUrl_ || this.quoteUrl_.isEmpty()) {
                String string = this.quoteUrl_ = this.useSimulateEnv_ ? defaultSimulatedQuoteUrl : defaultQuoteUrl;
            }
            if (null == this.tradeUrl_ || this.tradeUrl_.isEmpty()) {
                this.tradeUrl_ = this.useSimulateEnv_ ? defaultSimulatedTradeUrl : defaultTradeUrl;
            }
            Config config = new Config();
            config.user = this.user_;
            config.quoteAccessToken = this.quoteAccessToken_;
            config.tradeAccessToken = this.tradeAccessToken_;
            config.useSimulateEnv = this.useSimulateEnv_;
            config.quoteUrl = this.quoteUrl_;
            config.tradeUrl = this.tradeUrl_;
            return config;
        }

        public String getUser() {
            return this.user_;
        }

        public Builder setUser_(String user) {
            if (null != user) {
                this.user_ = user;
            }
            return this;
        }

        public String getQuoteAccessToken_() {
            return this.quoteAccessToken_;
        }

        public Builder setQuoteAccessToken(String quoteAccessToken) {
            if (null != quoteAccessToken) {
                this.quoteAccessToken_ = quoteAccessToken;
            }
            return this;
        }

        public String getTradeAccessToken() {
            return this.tradeAccessToken_;
        }

        public Builder setTradeAccessToken(String tradeAccessToken) {
            if (null != tradeAccessToken) {
                this.tradeAccessToken_ = tradeAccessToken;
            }
            return this;
        }

        public boolean getUseSimulateEnv() {
            return this.useSimulateEnv_;
        }

        public Builder setUseSimulateEnv(boolean useSimulateEnv) {
            this.useSimulateEnv_ = useSimulateEnv;
            return this;
        }

        public String getTradeUrl() {
            return this.tradeUrl_;
        }

        public Builder setTradeUrl(String tradeUrl) {
            if (null != tradeUrl) {
                this.tradeUrl_ = tradeUrl;
            }
            return this;
        }

        public String getQuoteUrl() {
            return this.quoteUrl_;
        }

        public Builder setQuoteUrl(String quoteUrl) {
            if (null != quoteUrl) {
                this.quoteUrl_ = quoteUrl;
            }
            return this;
        }
    }
}

