/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.avatar;

import com.github.natche.gravatarjavaclient.avatar.GravatarAvatarRequest;
import com.github.natche.gravatarjavaclient.enums.GravatarDefaultImageType;
import com.github.natche.gravatarjavaclient.enums.GravatarForceDefaultImage;
import com.github.natche.gravatarjavaclient.enums.GravatarUrlParameter;
import com.github.natche.gravatarjavaclient.enums.GravatarUseFullUrlParameters;
import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;

enum GravatarAvatarRequestHandler {
    INSTANCE;

    private final AtomicInteger builtUrlCount = new AtomicInteger(0);
    private static final String FORCE_DEFAULT_URL_TRUE_STRING = "y";

    public int getBuiltUrlCount() {
        return this.builtUrlCount.get();
    }

    String buildUrl(GravatarAvatarRequest request) {
        Preconditions.checkNotNull((Object)request);
        GravatarUseFullUrlParameters fullParams = request.getUseFullUrlParameters();
        StringBuilder urlBuilder = new StringBuilder(request.getProtocol().getAvatarRequestBaseurl());
        urlBuilder.append(request.getHash());
        urlBuilder.append(request.getShouldAppendJpgSuffix().getSuffix());
        String size = String.valueOf(request.getSize());
        String sizeParameter = GravatarUrlParameter.Size.constructUrlParameterWithValue(size, true, fullParams);
        urlBuilder.append(sizeParameter);
        String ratingsParameter = GravatarUrlParameter.Rating.constructUrlParameterWithValue(request.getRating().getUrlParameter(), fullParams);
        urlBuilder.append(ratingsParameter);
        GravatarDefaultImageType defaultImageType = request.getDefaultImageType();
        String defaultImageUrl = request.getDefaultImageUrl();
        if (defaultImageType != null) {
            String defaultImageTypeQueryString = GravatarUrlParameter.DefaultImageType.constructUrlParameterWithValue(defaultImageType.getUrlParameterValue(), fullParams);
            urlBuilder.append(defaultImageTypeQueryString);
        } else {
            String defaultImageUrlQueryString = GravatarUrlParameter.DefaultImageUrl.constructUrlParameterWithValue(defaultImageUrl, fullParams);
            urlBuilder.append(defaultImageUrlQueryString);
        }
        if (request.shouldForceDefaultImage() == GravatarForceDefaultImage.DoNotForce) {
            this.builtUrlCount.incrementAndGet();
            return urlBuilder.toString();
        }
        if (defaultImageUrl == null) {
            throw new GravatarJavaClientException("You must provide a default image URL if forcing default");
        }
        String forceDefaultImageQueryString = GravatarUrlParameter.ForceDefault.constructUrlParameterWithValue(FORCE_DEFAULT_URL_TRUE_STRING, fullParams);
        urlBuilder.append(forceDefaultImageQueryString);
        this.builtUrlCount.incrementAndGet();
        return urlBuilder.toString();
    }
}

