/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.avatar;

import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.github.natche.gravatarjavaclient.utils.InputValidator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;

enum GravatarAvatarRequestImageSaver {
    INSTANCE;

    private final AtomicInteger savedCount = new AtomicInteger(0);
    private final ImmutableList<String> SUPPORTED_IMAGE_FORMATS = ImmutableList.copyOf(Arrays.stream(ImageIO.getWriterFormatNames()).map(String::toLowerCase).distinct().toList());

    public int getSavedCount() {
        return this.savedCount.get();
    }

    public boolean saveTo(BufferedImage image, File file, String format) {
        Preconditions.checkNotNull((Object)image);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkArgument((boolean)this.SUPPORTED_IMAGE_FORMATS.contains((Object)format.toLowerCase()));
        Preconditions.checkArgument((boolean)InputValidator.isValidFilename(file.getName()));
        try {
            if (!ImageIO.write((RenderedImage)image, format.toLowerCase(), file)) {
                throw new IOException("Failed");
            }
            this.savedCount.incrementAndGet();
            return true;
        }
        catch (IOException e) {
            throw new GravatarJavaClientException("Failed to write the image to the file system");
        }
    }
}

