/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile.serialization;

import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileContactInfo;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileGalleryImage;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileInterest;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileLanguage;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfilePayments;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileUrl;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileVerifiedAccount;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.gson.annotations.SerializedName;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class GravatarProfile {
    private final String hash;
    @SerializedName(value="display_name")
    private final String displayName;
    @SerializedName(value="profile_url")
    private final String profileUrl;
    @SerializedName(value="avatar_url")
    private final String avatarUrl;
    @SerializedName(value="avatar_alt_text")
    private final String avatarAltText;
    private final String location;
    private final String description;
    @SerializedName(value="job_title")
    private final String jobTitle;
    private final String company;
    @SerializedName(value="verified_accounts")
    private final ImmutableList<GravatarProfileVerifiedAccount> verifiedAccounts;
    private final String pronunciation;
    private final String pronouns;
    private final String timezone;
    private final ImmutableList<GravatarProfileLanguage> languages;
    @SerializedName(value="first_name")
    private final String firstName;
    @SerializedName(value="last_name")
    private final String lastName;
    @SerializedName(value="is_organization")
    private final boolean isOrganization;
    private final ImmutableList<GravatarProfileUrl> links;
    private final ImmutableList<GravatarProfileInterest> interests;
    private final GravatarProfilePayments payments;
    @SerializedName(value="contact_info")
    private final GravatarProfileContactInfo contactInfo;
    private final ImmutableList<GravatarProfileGalleryImage> gallery;
    @SerializedName(value="number_verified_accounts")
    private final int numberVerifiedAccounts;
    @SerializedName(value="last_profile_edit")
    private final String lastProfileEdit;
    @SerializedName(value="registration_date")
    private final String registrationDate;

    public GravatarProfile(String hash, String displayName, String profileUrl, String avatarUrl, String avatarAltText, String location, String description, String jobTitle, String company, List<GravatarProfileVerifiedAccount> verifiedAccounts, String pronunciation, String pronouns, String timezone, List<GravatarProfileLanguage> languages, String firstName, String lastName, boolean isOrganization, List<GravatarProfileUrl> links, List<GravatarProfileInterest> interests, GravatarProfilePayments payments, GravatarProfileContactInfo contactInfo, List<GravatarProfileGalleryImage> gallery, int numberVerifiedAccounts, String lastProfileEdit, String registrationDate) {
        this.hash = (String)Preconditions.checkNotNull((Object)hash);
        this.displayName = displayName;
        this.profileUrl = (String)Preconditions.checkNotNull((Object)profileUrl);
        this.avatarUrl = avatarUrl;
        this.avatarAltText = avatarAltText;
        this.location = location;
        this.description = description;
        this.jobTitle = jobTitle;
        this.company = company;
        this.verifiedAccounts = verifiedAccounts != null ? ImmutableList.copyOf(verifiedAccounts) : ImmutableList.of();
        this.pronunciation = pronunciation;
        this.pronouns = pronouns;
        this.timezone = timezone;
        this.languages = languages != null ? ImmutableList.copyOf(languages) : ImmutableList.of();
        this.firstName = firstName;
        this.lastName = lastName;
        this.isOrganization = isOrganization;
        this.links = links != null ? ImmutableList.copyOf(links) : ImmutableList.of();
        this.interests = interests != null ? ImmutableList.copyOf(interests) : ImmutableList.of();
        this.payments = payments;
        this.contactInfo = contactInfo;
        this.gallery = gallery != null ? ImmutableList.copyOf(gallery) : ImmutableList.of();
        this.numberVerifiedAccounts = numberVerifiedAccounts;
        this.lastProfileEdit = lastProfileEdit;
        this.registrationDate = registrationDate;
    }

    public String getHash() {
        return this.hash;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getAvatarAltText() {
        return this.avatarAltText;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public String getCompany() {
        return this.company;
    }

    public ImmutableList<GravatarProfileVerifiedAccount> getVerifiedAccounts() {
        return this.verifiedAccounts;
    }

    public String getPronunciation() {
        return this.pronunciation;
    }

    public String getPronouns() {
        return this.pronouns;
    }

    public Optional<String> getTimezone() {
        return Optional.ofNullable(this.timezone);
    }

    public ImmutableList<GravatarProfileLanguage> getLanguages() {
        return this.languages;
    }

    public Optional<String> getFirstName() {
        return Optional.ofNullable(this.firstName);
    }

    public Optional<String> getLastName() {
        return Optional.ofNullable(this.lastName);
    }

    public boolean isOrganization() {
        return this.isOrganization;
    }

    public ImmutableList<GravatarProfileUrl> getLinks() {
        return this.links;
    }

    public ImmutableList<GravatarProfileInterest> getInterests() {
        return this.interests;
    }

    public Optional<GravatarProfilePayments> getPayments() {
        return Optional.ofNullable(this.payments);
    }

    public Optional<GravatarProfileContactInfo> getContactInfo() {
        return Optional.ofNullable(this.contactInfo);
    }

    public ImmutableList<GravatarProfileGalleryImage> getGallery() {
        return this.gallery;
    }

    public int getNumberVerifiedAccounts() {
        return this.numberVerifiedAccounts;
    }

    public Optional<Instant> getLastProfileEdit() {
        return this.lastProfileEdit == null ? Optional.empty() : Optional.of(Instant.parse(this.lastProfileEdit));
    }

    public Optional<Instant> getRegistrationDate() {
        return this.registrationDate == null ? Optional.empty() : Optional.of(Instant.parse(this.registrationDate));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarProfile)) {
            return false;
        }
        GravatarProfile that = (GravatarProfile)o;
        return this.isOrganization == that.isOrganization && this.numberVerifiedAccounts == that.numberVerifiedAccounts && Objects.equals(this.hash, that.hash) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.profileUrl, that.profileUrl) && Objects.equals(this.avatarUrl, that.avatarUrl) && Objects.equals(this.avatarAltText, that.avatarAltText) && Objects.equals(this.location, that.location) && Objects.equals(this.description, that.description) && Objects.equals(this.jobTitle, that.jobTitle) && Objects.equals(this.company, that.company) && Objects.equals(this.verifiedAccounts, that.verifiedAccounts) && Objects.equals(this.pronunciation, that.pronunciation) && Objects.equals(this.pronouns, that.pronouns) && Objects.equals(this.timezone, that.timezone) && Objects.equals(this.languages, that.languages) && Objects.equals(this.firstName, that.firstName) && Objects.equals(this.lastName, that.lastName) && Objects.equals(this.links, that.links) && Objects.equals(this.interests, that.interests) && Objects.equals(this.payments, that.payments) && Objects.equals(this.contactInfo, that.contactInfo) && Objects.equals(this.gallery, that.gallery) && Objects.equals(this.lastProfileEdit, that.lastProfileEdit) && Objects.equals(this.registrationDate, that.registrationDate);
    }

    public int hashCode() {
        int ret = this.hash.hashCode();
        ret = 31 * ret + Objects.hashCode(this.displayName);
        ret = 31 * ret + this.profileUrl.hashCode();
        ret = 31 * ret + Objects.hashCode(this.avatarUrl);
        ret = 31 * ret + Objects.hashCode(this.avatarAltText);
        ret = 31 * ret + Objects.hashCode(this.location);
        ret = 31 * ret + Objects.hashCode(this.description);
        ret = 31 * ret + Objects.hashCode(this.jobTitle);
        ret = 31 * ret + Objects.hashCode(this.company);
        ret = 31 * ret + this.verifiedAccounts.hashCode();
        ret = 31 * ret + Objects.hashCode(this.pronunciation);
        ret = 31 * ret + Objects.hashCode(this.pronouns);
        ret = 31 * ret + Objects.hashCode(this.timezone);
        ret = 31 * ret + this.languages.hashCode();
        ret = 31 * ret + Objects.hashCode(this.firstName);
        ret = 31 * ret + Objects.hashCode(this.lastName);
        ret = 31 * ret + (this.isOrganization ? 1 : 0);
        ret = 31 * ret + this.links.hashCode();
        ret = 31 * ret + this.interests.hashCode();
        ret = 31 * ret + Objects.hashCode(this.payments);
        ret = 31 * ret + Objects.hashCode(this.contactInfo);
        ret = 31 * ret + this.gallery.hashCode();
        ret = 31 * ret + this.numberVerifiedAccounts;
        ret = 31 * ret + Objects.hashCode(this.lastProfileEdit);
        ret = 31 * ret + Objects.hashCode(this.registrationDate);
        return ret;
    }

    public String toString() {
        return "GravatarProfile{hash=\"" + this.hash + "\", displayName=\"" + this.displayName + "\", profileUrl=\"" + this.profileUrl + "\", avatarUrl=\"" + this.avatarUrl + "\", avatarAltText=\"" + this.avatarAltText + "\", location=\"" + this.location + "\", description=\"" + this.description + "\", jobTitle=\"" + this.jobTitle + "\", company=\"" + this.company + "\", verifiedAccounts=" + String.valueOf(this.verifiedAccounts) + ", pronunciation=\"" + this.pronunciation + "\", pronouns=\"" + this.pronouns + "\", timezone=\"" + this.timezone + "\", languages=" + String.valueOf(this.languages) + ", firstName=\"" + this.firstName + "\", lastName=\"" + this.lastName + "\", isOrganization=" + this.isOrganization + ", links=" + String.valueOf(this.links) + ", interests=" + String.valueOf(this.interests) + ", payments=" + String.valueOf(this.payments) + ", contactInfo=" + String.valueOf(this.contactInfo) + ", gallery=" + String.valueOf(this.gallery) + ", numberVerifiedAccounts=" + this.numberVerifiedAccounts + ", lastProfileEdit=\"" + this.lastProfileEdit + "\", registrationDate=\"" + this.registrationDate + "\"}";
    }
}

