/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.avatar;

import com.github.natche.gravatarjavaclient.avatar.GravatarAvatarRequest;
import com.github.natche.gravatarjavaclient.enums.GravatarDefaultImageType;
import com.github.natche.gravatarjavaclient.enums.GravatarForceDefaultImage;
import com.github.natche.gravatarjavaclient.enums.GravatarUrlParameter;
import com.github.natche.gravatarjavaclient.enums.GravatarUseFullUrlParameters;
import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.google.common.base.Preconditions;

enum GravatarAvatarRequestHandler {
    INSTANCE;

    private static final String FORCE_DEFAULT_URL_TRUE_STRING = "y";

    String buildUrl(GravatarAvatarRequest gravatarAvatarRequest) {
        Preconditions.checkNotNull((Object)gravatarAvatarRequest);
        GravatarUseFullUrlParameters fullParams = gravatarAvatarRequest.getUseFullUrlParameters();
        StringBuilder urlBuilder = new StringBuilder(gravatarAvatarRequest.getProtocol().getAvatarRequestBaseurl());
        urlBuilder.append(gravatarAvatarRequest.getHash());
        urlBuilder.append(gravatarAvatarRequest.getShouldAppendJpgSuffix().getSuffix());
        String size = String.valueOf(gravatarAvatarRequest.getSize());
        String sizeParameter = GravatarUrlParameter.SIZE.constructUrlParameterWithValue(size, true, fullParams);
        urlBuilder.append(sizeParameter);
        String ratingsParameter = GravatarUrlParameter.RATING.constructUrlParameterWithValue(gravatarAvatarRequest.getRating().getUrlParameter(), fullParams);
        urlBuilder.append(ratingsParameter);
        GravatarDefaultImageType defaultImageType = gravatarAvatarRequest.getDefaultImageType();
        String defaultImageUrl = gravatarAvatarRequest.getDefaultImageUrl();
        if (defaultImageType != null) {
            String defaultImageTypeQueryString = GravatarUrlParameter.DEFAULT_IMAGE_TYPE.constructUrlParameterWithValue(defaultImageType.getUrlParameterValue(), fullParams);
            urlBuilder.append(defaultImageTypeQueryString);
        } else {
            String defaultImageUrlQueryString = GravatarUrlParameter.DEFAULT_IMAGE_URL.constructUrlParameterWithValue(defaultImageUrl, fullParams);
            urlBuilder.append(defaultImageUrlQueryString);
        }
        if (gravatarAvatarRequest.shouldForceDefaultImage() == GravatarForceDefaultImage.DoNotForce) {
            return urlBuilder.toString();
        }
        if (defaultImageUrl == null) {
            throw new GravatarJavaClientException("Must provide default URL if forcing default");
        }
        String forceDefaultImageQueryString = GravatarUrlParameter.FORCE_DEFAULT.constructUrlParameterWithValue(FORCE_DEFAULT_URL_TRUE_STRING, fullParams);
        urlBuilder.append(forceDefaultImageQueryString);
        return urlBuilder.toString();
    }
}

