/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.enums;

import com.github.natche.gravatarjavaclient.enums.GravatarUseFullUrlParameters;
import com.google.common.base.Preconditions;

public enum GravatarUrlParameter {
    SIZE("s", "size"),
    DEFAULT_IMAGE_URL("d", "default"),
    FORCE_DEFAULT("f", "forcedefault"),
    DEFAULT_IMAGE_TYPE("d", "default"),
    RATING("r", "rating");

    private static final String INITIAL_URL_PARAMETER_PREFIX = "?";
    private static final String NON_INITIAL_URL_PARAMETER_PREFIX = "&";
    private final String shortUrlParameter;
    private final String fullUrlParameter;

    private GravatarUrlParameter(String urlParameter, String fullUrlParameter) {
        this.shortUrlParameter = urlParameter;
        this.fullUrlParameter = fullUrlParameter;
    }

    public <T> String constructUrlParameterWithValue(T value, GravatarUseFullUrlParameters useFullUrlParameter) {
        Preconditions.checkNotNull(value);
        return this.constructUrlParameterWithValue(value, false, useFullUrlParameter);
    }

    public <T> String constructUrlParameterWithValue(T value, boolean firstParameter, GravatarUseFullUrlParameters useFullUrlParameter) {
        Preconditions.checkNotNull(value);
        Preconditions.checkNotNull((Object)((Object)useFullUrlParameter));
        String prefix = firstParameter ? INITIAL_URL_PARAMETER_PREFIX : NON_INITIAL_URL_PARAMETER_PREFIX;
        return prefix + (useFullUrlParameter.shouldUseFullParams() ? this.fullUrlParameter : this.shortUrlParameter) + "=" + String.valueOf(value);
    }
}

