/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile;

import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.github.natche.gravatarjavaclient.profile.GravatarProfileRequestHandler;
import com.github.natche.gravatarjavaclient.profile.GravatarProfileTokenProvider;
import com.github.natche.gravatarjavaclient.profile.gson.GsonProvider;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfile;
import com.github.natche.gravatarjavaclient.utils.Hasher;
import com.github.natche.gravatarjavaclient.utils.InputValidator;
import com.github.natche.gravatarjavaclient.utils.ResourceReader;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Objects;

public final class GravatarProfileRequest {
    private GravatarProfileTokenProvider tokenSupplier;
    private final String hashOrId;

    private GravatarProfileRequest(String hashOrId) {
        this.hashOrId = hashOrId;
    }

    public static GravatarProfileRequest fromHashOrId(String hashOrId) {
        Preconditions.checkNotNull((Object)hashOrId);
        Preconditions.checkArgument((!hashOrId.trim().isEmpty() ? 1 : 0) != 0);
        return new GravatarProfileRequest(hashOrId);
    }

    public static GravatarProfileRequest fromEmail(String email) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkArgument((!email.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)InputValidator.from(email).isValidEmailAddress());
        return new GravatarProfileRequest(Hasher.SHA256_HASHER.hash(email));
    }

    public GravatarProfileRequest setTokenSupplier(GravatarProfileTokenProvider tokenSupplier) {
        Preconditions.checkNotNull((Object)tokenSupplier);
        this.tokenSupplier = tokenSupplier;
        return this;
    }

    public String getHashOrId() {
        return this.hashOrId;
    }

    public GravatarProfile getProfile() {
        byte[] token = this.tokenSupplier == null ? null : this.tokenSupplier.getToken();
        return GravatarProfileRequestHandler.INSTANCE.getProfile(token, this.hashOrId);
    }

    @CanIgnoreReturnValue
    public boolean writeToFile(File file) {
        return this.writeToFile(GsonProvider.INSTANCE.get(), file);
    }

    @CanIgnoreReturnValue
    public boolean writeToFile(Gson serializer, File file) {
        boolean bl;
        Preconditions.checkNotNull((Object)serializer);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)file.exists());
        Preconditions.checkArgument((boolean)ResourceReader.isValidFilename(file.getName()));
        FileWriter writer = new FileWriter(file);
        try {
            serializer.toJson((Object)this.getProfile(), (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new GravatarJavaClientException(e);
            }
        }
        writer.close();
        return bl;
    }

    public int hashCode() {
        int ret = this.hashOrId.hashCode();
        if (this.tokenSupplier != null) {
            ret = 31 * ret + Arrays.hashCode(this.tokenSupplier.getToken());
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarProfileRequest)) {
            return false;
        }
        GravatarProfileRequest other = (GravatarProfileRequest)o;
        return this.hashOrId.equals(other.hashOrId) && Objects.equals(this.tokenSupplier, other.tokenSupplier);
    }

    public String toString() {
        return "GravatarProfileRequest{hash=\"" + this.hashOrId + "\", tokenSupplier=" + String.valueOf(this.tokenSupplier) + "}";
    }
}

