/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile;

import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.github.natche.gravatarjavaclient.profile.gson.GsonProvider;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfile;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileRequestResult;
import com.github.natche.gravatarjavaclient.utils.ResourceReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

enum GravatarProfileRequestHandler {
    INSTANCE;

    private static final Charset ENCODE_CHARSET;
    private static final int HTTPS_PORT = 443;
    private static final String API_HOST = "api.gravatar.com";
    private static final String API_VERSION = "3";
    private static final String CRLF = "\r\n";
    private final ArrayList<GravatarProfileRequestResult> AUTHENTICATED_REQUESTS = new ArrayList();
    private final ArrayList<GravatarProfileRequestResult> UNAUTHENTICATED_REQUESTS = new ArrayList();

    public ImmutableList<GravatarProfileRequestResult> getAuthenticatedRequestResults() {
        return ImmutableList.copyOf(this.AUTHENTICATED_REQUESTS);
    }

    public ImmutableList<GravatarProfileRequestResult> getUnauthenticatedRequestResults() {
        return ImmutableList.copyOf(this.UNAUTHENTICATED_REQUESTS);
    }

    /*
     * Loose catch block
     */
    GravatarProfile getProfile(byte[] bearerToken, String nameOrHash) {
        GravatarProfile gravatarProfile;
        SSLSocket socket;
        AtomicBoolean failed;
        Instant requestTime;
        block16: {
            GravatarProfileRequestResult result;
            block15: {
                block14: {
                    Preconditions.checkNotNull((Object)nameOrHash);
                    Preconditions.checkArgument((!nameOrHash.trim().isEmpty() ? 1 : 0) != 0);
                    requestTime = Instant.now();
                    failed = new AtomicBoolean(true);
                    SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                    socket = (SSLSocket)factory.createSocket(API_HOST, 443);
                    socket.setEnabledCipherSuites(socket.getSupportedCipherSuites());
                    OutputStream outputStream = socket.getOutputStream();
                    String httpRequest = "GET /v3/profiles/" + nameOrHash + " HTTP/1.1\r\nHost: api.gravatar.com\r\n";
                    outputStream.write(this.encode(httpRequest));
                    if (bearerToken != null) {
                        outputStream.write(this.encode("Authorization: Bearer "));
                        outputStream.write(bearerToken);
                    }
                    outputStream.write(this.encode("\r\n\r\n"));
                    requestTime = Instant.now();
                    outputStream.flush();
                    BufferedReader br = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    String response = ResourceReader.from(br).skipHeaders().readChunkedBody();
                    if (response.contains("error")) {
                        JsonObject responseObject = (JsonObject)GsonProvider.INSTANCE.get().fromJson(response, JsonObject.class);
                        throw new RuntimeException("Gravatar API error: " + responseObject.get("error").getAsString());
                    }
                    GravatarProfile ret = (GravatarProfile)GsonProvider.INSTANCE.get().fromJson(response, GravatarProfile.class);
                    failed.set(false);
                    gravatarProfile = ret;
                    if (socket == null) break block14;
                    socket.close();
                }
                result = new GravatarProfileRequestResult(requestTime, !failed.get());
                if (bearerToken != null) break block15;
                this.UNAUTHENTICATED_REQUESTS.add(result);
                break block16;
            }
            this.AUTHENTICATED_REQUESTS.add(result);
        }
        return gravatarProfile;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (socket != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new GravatarJavaClientException(e);
                    }
                }
                catch (Throwable throwable3) {
                    GravatarProfileRequestResult result2 = new GravatarProfileRequestResult(requestTime, !failed.get());
                    if (bearerToken == null) {
                        this.UNAUTHENTICATED_REQUESTS.add(result2);
                    } else {
                        this.AUTHENTICATED_REQUESTS.add(result2);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private byte[] encode(String string) {
        return string.getBytes(ENCODE_CHARSET);
    }

    static {
        ENCODE_CHARSET = StandardCharsets.US_ASCII;
    }
}

