/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;

public final class GravatarProfileTokenProvider {
    private final Supplier<byte[]> tokenProvider;
    private final String source;

    public GravatarProfileTokenProvider(Supplier<byte[]> tokenProvider, String source) {
        Preconditions.checkNotNull(tokenProvider);
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkArgument((!source.trim().isEmpty() ? 1 : 0) != 0);
        this.tokenProvider = tokenProvider;
        this.source = source;
    }

    public byte[] getToken() {
        return this.tokenProvider.get();
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarProfileTokenProvider)) {
            return false;
        }
        GravatarProfileTokenProvider other = (GravatarProfileTokenProvider)o;
        return this.source.equals(other.source);
    }

    public String toString() {
        return "GravatarProfileTokenProvider{source=\"" + this.source + "\"}";
    }
}

