/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile.gson;

import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfile;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileContactInfo;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileGalleryImage;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileInterest;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileLanguage;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfilePayments;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileUrl;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfileVerifiedAccount;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;

public final class GravatarProfileDeserializer
implements JsonDeserializer<GravatarProfile> {
    public GravatarProfile deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        String hash = jsonObject.get("hash").getAsString();
        String profileUrl = jsonObject.get("profile_url").getAsString();
        String displayName = this.getOptionalString(jsonObject, "display_name");
        String avatarUrl = this.getOptionalString(jsonObject, "avatar_url");
        String avatarAltText = this.getOptionalString(jsonObject, "avatar_alt_text");
        String location = this.getOptionalString(jsonObject, "location");
        String description = this.getOptionalString(jsonObject, "description");
        String jobTitle = this.getOptionalString(jsonObject, "job_title");
        String company = this.getOptionalString(jsonObject, "company");
        String pronunciation = this.getOptionalString(jsonObject, "pronunciation");
        String pronouns = this.getOptionalString(jsonObject, "pronouns");
        String timezone = this.getOptionalString(jsonObject, "timezone");
        String firstName = this.getOptionalString(jsonObject, "first_name");
        String lastName = this.getOptionalString(jsonObject, "last_name");
        boolean isOrganization = jsonObject.has("is_organization") && jsonObject.get("is_organization").getAsBoolean();
        String lastProfileEdit = this.getOptionalString(jsonObject, "last_profile_edit");
        String registrationDate = this.getOptionalString(jsonObject, "registration_date");
        List<GravatarProfileVerifiedAccount> verifiedAccounts = this.getOptionalList(jsonObject, "verified_accounts", context, new TypeToken<List<GravatarProfileVerifiedAccount>>(){}.getType());
        List<GravatarProfileLanguage> languages = this.getOptionalList(jsonObject, "languages", context, new TypeToken<List<GravatarProfileLanguage>>(){}.getType());
        List<GravatarProfileUrl> links = this.getOptionalList(jsonObject, "links", context, new TypeToken<List<GravatarProfileUrl>>(){}.getType());
        List<GravatarProfileInterest> interests = this.getOptionalList(jsonObject, "interests", context, new TypeToken<List<GravatarProfileInterest>>(){}.getType());
        List<GravatarProfileGalleryImage> gallery = this.getOptionalList(jsonObject, "gallery", context, new TypeToken<List<GravatarProfileGalleryImage>>(){}.getType());
        GravatarProfilePayments payments = this.getOptionalObject(jsonObject, "payments", context, GravatarProfilePayments.class);
        GravatarProfileContactInfo contactInfo = this.getOptionalObject(jsonObject, "contact_info", context, GravatarProfileContactInfo.class);
        int numberVerifiedAccounts = jsonObject.has("number_verified_accounts") ? jsonObject.get("number_verified_accounts").getAsInt() : 0;
        return new GravatarProfile(hash, displayName, profileUrl, avatarUrl, avatarAltText, location, description, jobTitle, company, verifiedAccounts, pronunciation, pronouns, timezone, languages, firstName, lastName, isOrganization, links, interests, payments, contactInfo, gallery, numberVerifiedAccounts, lastProfileEdit, registrationDate);
    }

    private String getOptionalString(JsonObject jsonObject, String memberName) {
        return jsonObject.has(memberName) ? jsonObject.get(memberName).getAsString() : null;
    }

    private <T> List<T> getOptionalList(JsonObject jsonObject, String memberName, JsonDeserializationContext context, Type type) {
        return jsonObject.has(memberName) ? (List)context.deserialize(jsonObject.get(memberName), type) : ImmutableList.of();
    }

    private <T> T getOptionalObject(JsonObject jsonObject, String memberName, JsonDeserializationContext context, Class<T> classOfT) {
        return (T)(jsonObject.has(memberName) ? context.deserialize(jsonObject.get(memberName), classOfT) : null);
    }
}

