/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile.serialization;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.gson.annotations.SerializedName;

@Immutable
public final class GravatarProfileUrl {
    private final String label;
    @SerializedName(value="value")
    private final String url;

    public GravatarProfileUrl(String label, String url) {
        Preconditions.checkNotNull((Object)label);
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkArgument((!label.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!url.trim().isEmpty() ? 1 : 0) != 0);
        this.label = label;
        this.url = url;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "GravatarProfileUrl{label=\"" + this.label + "\", url=\"" + this.url + "\"}";
    }

    public int hashCode() {
        int ret = this.label.hashCode();
        ret = 31 * ret + this.url.hashCode();
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarProfileUrl)) {
            return false;
        }
        GravatarProfileUrl other = (GravatarProfileUrl)o;
        return this.label.equals(other.label) && this.url.equals(other.url);
    }
}

