/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.utils;

import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public final class Hasher {
    public static final Hasher SHA256_HASHER = Hasher.fromAlgorithm("SHA-256");
    private static final int HEX_BASE = 16;
    private final String algorithm;

    private Hasher(String algorithm) {
        this.algorithm = algorithm;
    }

    public static Hasher fromAlgorithm(String algorithm) {
        Preconditions.checkNotNull((Object)algorithm);
        Preconditions.checkArgument((!algorithm.trim().isEmpty() ? 1 : 0) != 0);
        return new Hasher(algorithm);
    }

    public String hash(String input) {
        MessageDigest messageDigest;
        Preconditions.checkNotNull((Object)input);
        try {
            messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GravatarJavaClientException(e.getMessage());
        }
        CharBuffer charBuffer = CharBuffer.wrap(input.trim().toLowerCase().toCharArray());
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        byte[] digest = messageDigest.digest(bytes);
        BigInteger number = new BigInteger(1, digest);
        return number.toString(16);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Hasher)) {
            return false;
        }
        Hasher other = (Hasher)o;
        return this.algorithm.equals(other.algorithm);
    }

    public int hashCode() {
        return 31 * this.algorithm.hashCode();
    }

    public String toString() {
        return "Hasher{algorithm=\"" + this.algorithm + "\"}";
    }
}

