/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.utils;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public final class InputValidator {
    private static final Pattern EMAIL_ADDRESS_REGEX_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
    private final String input;

    private InputValidator(String input) {
        this.input = input;
    }

    public static InputValidator from(String input) {
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkArgument((!input.trim().isEmpty() ? 1 : 0) != 0);
        return new InputValidator(input);
    }

    public boolean isValidEmailAddress() {
        return EMAIL_ADDRESS_REGEX_PATTERN.matcher(this.input).matches();
    }

    public boolean isValidImageUrl() {
        try {
            ImageIO.read(new URL(this.input)).getWidth();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputValidator)) {
            return false;
        }
        InputValidator other = (InputValidator)o;
        return this.input.equals(other.input);
    }

    public int hashCode() {
        return 31 * this.input.hashCode();
    }

    public String toString() {
        return "InputValidator{input=\"" + this.input + "\"}";
    }
}

