/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;

public final class ResourceReader {
    private static final ImmutableList<Character> INVALID_FILENAME_CHARS = ImmutableList.of((Object)Character.valueOf('<'), (Object)Character.valueOf('>'), (Object)Character.valueOf(':'), (Object)Character.valueOf('\\'), (Object)Character.valueOf('|'), (Object)Character.valueOf('?'), (Object)Character.valueOf('*'), (Object)Character.valueOf('/'), (Object)Character.valueOf('\''), (Object)Character.valueOf('\"'), (Object)Character.valueOf('\u0000'));
    private final BufferedReader resourceReader;

    private ResourceReader(BufferedReader resourceReader) {
        this.resourceReader = resourceReader;
    }

    public static ResourceReader from(BufferedReader resourceReader) {
        Preconditions.checkNotNull((Object)resourceReader);
        return new ResourceReader(resourceReader);
    }

    public static boolean isValidFilename(String filename) {
        Preconditions.checkNotNull((Object)filename);
        Preconditions.checkArgument((!filename.isEmpty() ? 1 : 0) != 0);
        for (char c : filename.toCharArray()) {
            if (!INVALID_FILENAME_CHARS.contains((Object)Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }

    public ResourceReader skipHeaders() throws IOException {
        String line;
        while ((line = this.resourceReader.readLine()) != null && !line.isEmpty()) {
        }
        return this;
    }

    public String readChunkedBody() throws IOException {
        int chunkSize;
        String chunkSizeLine;
        StringBuilder responseBody = new StringBuilder();
        while ((chunkSizeLine = this.resourceReader.readLine()) != null && !chunkSizeLine.isEmpty() && (chunkSize = Integer.parseInt(chunkSizeLine.trim(), 16)) != 0) {
            int totalBytesRead;
            int bytesRead;
            char[] chunk = new char[chunkSize];
            for (totalBytesRead = 0; totalBytesRead < chunkSize && (bytesRead = this.resourceReader.read(chunk, totalBytesRead, chunkSize - totalBytesRead)) != -1; totalBytesRead += bytesRead) {
            }
            responseBody.append(chunk, 0, totalBytesRead);
            this.resourceReader.readLine();
        }
        return responseBody.toString();
    }

    public int hashCode() {
        return 31 * this.resourceReader.hashCode();
    }

    public String toString() {
        return "ResourceReader{resourceReader=" + String.valueOf(this.resourceReader) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceReader)) {
            return false;
        }
        ResourceReader other = (ResourceReader)o;
        return other.resourceReader.equals(this.resourceReader);
    }
}

