/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile;

import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.github.natche.gravatarjavaclient.profile.gson.GsonProvider;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfile;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

enum GravatarProfileRequestHandler {
    INSTANCE;

    private static final HttpClient HTTP_CLIENT;
    private final AtomicInteger authenticatedRequestCount = new AtomicInteger();
    private final AtomicInteger unauthenticatedRequestCount = new AtomicInteger();

    public int getAuthenticatedRequestCount() {
        return this.authenticatedRequestCount.get();
    }

    public int getUnauthenticatedRequestCount() {
        return this.unauthenticatedRequestCount.get();
    }

    GravatarProfile getProfile(String token, String nameOrHash) {
        Preconditions.checkNotNull((Object)nameOrHash);
        Preconditions.checkArgument((!nameOrHash.trim().isEmpty() ? 1 : 0) != 0);
        try {
            HttpRequest request;
            HttpResponse<String> response;
            String body;
            String url = "https://api.gravatar.com/v3/profiles/" + nameOrHash;
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).GET();
            if (token != null) {
                requestBuilder.header("Authorization", "Bearer " + token);
            }
            if ((body = (response = HTTP_CLIENT.send(request = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).body()).contains("error")) {
                JsonObject responseObject = (JsonObject)GsonProvider.INSTANCE.get().fromJson(body, JsonObject.class);
                throw new RuntimeException("Gravatar API error: " + responseObject.get("error").getAsString());
            }
            GravatarProfile gravatarProfile = (GravatarProfile)GsonProvider.INSTANCE.get().fromJson(body, GravatarProfile.class);
            return gravatarProfile;
        }
        catch (Exception e) {
            throw new GravatarJavaClientException(e);
        }
        finally {
            if (token == null) {
                this.unauthenticatedRequestCount.incrementAndGet();
            } else {
                this.authenticatedRequestCount.incrementAndGet();
            }
        }
    }

    static {
        HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }
}

