/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile.serialization;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;

public final class GravatarProfileLanguage {
    @SerializedName(value="code")
    private final String code;
    @SerializedName(value="name")
    private final String name;
    @SerializedName(value="is_primary")
    private final boolean isPrimary;
    @SerializedName(value="order")
    private final int order;

    public GravatarProfileLanguage(String code, String name, boolean isPrimary, int order) {
        Preconditions.checkNotNull((Object)code);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((!name.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!code.trim().isEmpty() ? 1 : 0) != 0);
        this.code = code;
        this.name = name;
        this.isPrimary = isPrimary;
        this.order = order;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarProfileLanguage)) {
            return false;
        }
        GravatarProfileLanguage other = (GravatarProfileLanguage)o;
        return this.isPrimary == other.isPrimary && this.order == other.order && this.code.equals(other.code) && this.name.equals(other.name);
    }

    public int hashCode() {
        int ret = this.code.hashCode();
        ret = 31 * ret + this.name.hashCode();
        ret = 31 * ret + Boolean.hashCode(this.isPrimary);
        ret = 31 * ret + Integer.hashCode(this.order);
        return ret;
    }

    public String toString() {
        return "GravatarProfileLanguage{code=\"" + this.code + "\", name=\"" + this.name + "\", isPrimary=" + this.isPrimary + ", order=" + this.order + "}";
    }
}

