/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.utils;

import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public enum Hasher {
    SHA256("SHA-256");

    private static final int HEX_BASE = 16;
    private final String algorithm;

    private Hasher(String algorithm) {
        this.algorithm = algorithm;
    }

    public String hash(String input) {
        MessageDigest messageDigest;
        Preconditions.checkNotNull((Object)input);
        try {
            messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new GravatarJavaClientException(e.getMessage());
        }
        CharBuffer charBuffer = CharBuffer.wrap(input.trim().toLowerCase().toCharArray());
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        byte[] digest = messageDigest.digest(bytes);
        BigInteger number = new BigInteger(1, digest);
        return number.toString(16);
    }
}

