/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.utils;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.regex.Pattern;

public final class InputValidator {
    private static final Pattern EMAIL_ADDRESS_REGEX_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])");
    private static final ImmutableList<Character> INVALID_FILENAME_CHARS = ImmutableList.of((Object)Character.valueOf('<'), (Object)Character.valueOf('>'), (Object)Character.valueOf(':'), (Object)Character.valueOf('\\'), (Object)Character.valueOf('|'), (Object)Character.valueOf('?'), (Object)Character.valueOf('*'), (Object)Character.valueOf('/'), (Object)Character.valueOf('\''), (Object)Character.valueOf('\"'), (Object)Character.valueOf('\u0000'));

    public static boolean isValidEmailAddress(String input) {
        if (input == null) {
            return false;
        }
        if (input.trim().isEmpty()) {
            return false;
        }
        return EMAIL_ADDRESS_REGEX_PATTERN.matcher(input).matches();
    }

    public static boolean isValidImageUrl(String input) {
        if (input == null) {
            return false;
        }
        if (input.trim().isEmpty()) {
            return false;
        }
        try {
            URI.create(input).toURL();
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static boolean isValidFilename(String input) {
        if (input == null) {
            return false;
        }
        if (input.trim().isEmpty()) {
            return false;
        }
        for (char c : input.toCharArray()) {
            if (!INVALID_FILENAME_CHARS.contains((Object)Character.valueOf(c))) continue;
            return false;
        }
        return true;
    }
}

