/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.avatar;

import com.github.natche.gravatarjavaclient.avatar.GravatarAvatarRequestHandler;
import com.github.natche.gravatarjavaclient.avatar.GravatarRequestImageSaver;
import com.github.natche.gravatarjavaclient.enums.GravatarDefaultImageType;
import com.github.natche.gravatarjavaclient.enums.GravatarForceDefaultImage;
import com.github.natche.gravatarjavaclient.enums.GravatarProtocol;
import com.github.natche.gravatarjavaclient.enums.GravatarRating;
import com.github.natche.gravatarjavaclient.enums.GravatarUseFullUrlParameters;
import com.github.natche.gravatarjavaclient.enums.GravatarUseJpgSuffix;
import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.github.natche.gravatarjavaclient.utils.Hasher;
import com.github.natche.gravatarjavaclient.utils.InputValidator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.imageio.ImageIO;

public final class GravatarAvatarRequest {
    private static final Range<Integer> IMAGE_SIZE_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2048));
    private static final int DEFAULT_IMAGE_SIZE = 80;
    private final String hash;
    private GravatarUseJpgSuffix shouldAppendJpgSuffix = GravatarUseJpgSuffix.False;
    private int size = 80;
    private GravatarRating rating = GravatarRating.Pg;
    private GravatarForceDefaultImage forceDefaultImage = GravatarForceDefaultImage.DoNotForce;
    private GravatarDefaultImageType defaultImageType = GravatarDefaultImageType.IdentIcon;
    private GravatarProtocol protocol = GravatarProtocol.Https;
    private GravatarUseFullUrlParameters useFullUrlParameters = GravatarUseFullUrlParameters.False;
    private String defaultImageUrl = null;

    private GravatarAvatarRequest(String hash) {
        this.hash = hash;
    }

    public static GravatarAvatarRequest fromEmail(String email) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkArgument((!email.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)InputValidator.isValidEmailAddress(email));
        String hash = Hasher.SHA256.hash(email);
        return new GravatarAvatarRequest(hash);
    }

    public static GravatarAvatarRequest fromHash(String hash) {
        Preconditions.checkNotNull((Object)hash);
        Preconditions.checkArgument((!hash.trim().isEmpty() ? 1 : 0) != 0);
        return new GravatarAvatarRequest(hash);
    }

    public String getHash() {
        return this.hash;
    }

    @CanIgnoreReturnValue
    public GravatarAvatarRequest setDefaultImageUrl(String defaultImageUrl) {
        Preconditions.checkNotNull((Object)defaultImageUrl);
        Preconditions.checkArgument((!defaultImageUrl.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)InputValidator.isValidImageUrl(defaultImageUrl));
        this.defaultImageUrl = defaultImageUrl;
        this.defaultImageType = null;
        return this;
    }

    public String getDefaultImageUrl() {
        return this.defaultImageUrl;
    }

    @CanIgnoreReturnValue
    public GravatarAvatarRequest setUseFullUrlParameters(GravatarUseFullUrlParameters useFullUrlParameters) {
        Preconditions.checkNotNull((Object)((Object)useFullUrlParameters));
        this.useFullUrlParameters = useFullUrlParameters;
        return this;
    }

    public GravatarUseFullUrlParameters getUseFullUrlParameters() {
        return this.useFullUrlParameters;
    }

    @CanIgnoreReturnValue
    public GravatarAvatarRequest setProtocol(GravatarProtocol protocol) {
        Preconditions.checkNotNull((Object)((Object)protocol));
        this.protocol = protocol;
        return this;
    }

    public GravatarProtocol getProtocol() {
        return this.protocol;
    }

    @CanIgnoreReturnValue
    public GravatarAvatarRequest setDefaultImageType(GravatarDefaultImageType imageType) {
        Preconditions.checkNotNull((Object)((Object)imageType));
        this.defaultImageType = imageType;
        this.defaultImageUrl = null;
        return this;
    }

    public GravatarDefaultImageType getDefaultImageType() {
        return this.defaultImageType;
    }

    @CanIgnoreReturnValue
    public GravatarAvatarRequest setForceDefaultImage(GravatarForceDefaultImage forceDefaultImage) {
        Preconditions.checkNotNull((Object)((Object)forceDefaultImage));
        this.forceDefaultImage = forceDefaultImage;
        return this;
    }

    public GravatarForceDefaultImage shouldForceDefaultImage() {
        return this.forceDefaultImage;
    }

    @CanIgnoreReturnValue
    public GravatarAvatarRequest setRating(GravatarRating rating) {
        Preconditions.checkNotNull((Object)((Object)rating));
        this.rating = rating;
        return this;
    }

    public GravatarRating getRating() {
        return this.rating;
    }

    @CanIgnoreReturnValue
    public GravatarAvatarRequest setShouldAppendJpgSuffix(GravatarUseJpgSuffix useJpgSuffix) {
        Preconditions.checkNotNull((Object)((Object)useJpgSuffix));
        this.shouldAppendJpgSuffix = useJpgSuffix;
        return this;
    }

    public GravatarUseJpgSuffix getShouldAppendJpgSuffix() {
        return this.shouldAppendJpgSuffix;
    }

    @CanIgnoreReturnValue
    public GravatarAvatarRequest setSize(int imageSize) {
        Preconditions.checkArgument((boolean)IMAGE_SIZE_RANGE.contains((Comparable)Integer.valueOf(imageSize)));
        this.size = imageSize;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public String getRequestUrl() {
        return GravatarAvatarRequestHandler.INSTANCE.buildUrl(this);
    }

    public BufferedImage getBufferedImage() {
        try {
            String requestUrl = this.getRequestUrl();
            return ImageIO.read(URI.create(requestUrl).toURL());
        }
        catch (IOException e) {
            throw new GravatarJavaClientException(e);
        }
    }

    @CheckReturnValue
    public boolean saveAsPng(File saveTo) {
        Preconditions.checkNotNull((Object)saveTo);
        Preconditions.checkArgument((!saveTo.isDirectory() ? 1 : 0) != 0);
        return this.saveTo(saveTo, "png");
    }

    @CheckReturnValue
    public boolean saveAsJpg(File saveTo) {
        Preconditions.checkNotNull((Object)saveTo);
        Preconditions.checkArgument((!saveTo.isDirectory() ? 1 : 0) != 0);
        return this.saveTo(saveTo, "jpg");
    }

    @CheckReturnValue
    public boolean saveTo(File saveTo, String format) {
        Preconditions.checkNotNull((Object)saveTo);
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkArgument((!format.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!saveTo.isDirectory() ? 1 : 0) != 0);
        return GravatarRequestImageSaver.INSTANCE.saveTo(this.getBufferedImage(), saveTo, format);
    }

    public String toString() {
        return "GravatarAvatarRequest{hash=\"" + this.hash + "\", size=" + this.size + ", rating=" + String.valueOf((Object)this.rating) + ", forceDefaultImage=" + String.valueOf((Object)this.forceDefaultImage) + ", defaultImageType=" + String.valueOf((Object)this.defaultImageType) + ", protocol=" + String.valueOf((Object)this.protocol) + ", useFullUrlParameters=" + String.valueOf((Object)this.useFullUrlParameters) + ", defaultImageUrl=\"" + this.defaultImageUrl + "\", }";
    }

    public int hashCode() {
        int ret = this.hash.hashCode();
        ret = 31 * ret + this.shouldAppendJpgSuffix.hashCode();
        ret = 31 * ret + Integer.hashCode(this.size);
        ret = 31 * ret + this.rating.hashCode();
        ret = 31 * ret + this.forceDefaultImage.hashCode();
        ret = 31 * ret + Objects.hashCode((Object)this.defaultImageType);
        ret = 31 * ret + this.protocol.hashCode();
        ret = 31 * ret + this.useFullUrlParameters.hashCode();
        ret = 31 * ret + Objects.hash(this.defaultImageUrl);
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarAvatarRequest)) {
            return false;
        }
        GravatarAvatarRequest other = (GravatarAvatarRequest)o;
        return Objects.equals(this.hash, other.hash) && Objects.equals((Object)this.shouldAppendJpgSuffix, (Object)other.shouldAppendJpgSuffix) && this.size == other.size && Objects.equals((Object)this.rating, (Object)other.rating) && Objects.equals((Object)this.forceDefaultImage, (Object)other.forceDefaultImage) && Objects.equals((Object)this.defaultImageType, (Object)other.defaultImageType) && Objects.equals((Object)this.protocol, (Object)other.protocol) && Objects.equals((Object)this.useFullUrlParameters, (Object)other.useFullUrlParameters) && Objects.equals(this.defaultImageUrl, other.defaultImageUrl);
    }
}

