/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.avatar;

import com.github.natche.gravatarjavaclient.avatar.GravatarRequestImageSaver;
import com.github.natche.gravatarjavaclient.enums.GravatarQrImageType;
import com.github.natche.gravatarjavaclient.enums.GravatarQrImageVersion;
import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.github.natche.gravatarjavaclient.utils.Hasher;
import com.github.natche.gravatarjavaclient.utils.InputValidator;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;

public final class GravatarQrCodeRequest {
    private static final String BASE_URL = "https://gravatar.com/";
    private static final Range<Integer> IMAGE_LENGTH_RANGE = Range.closed((Comparable)Integer.valueOf(80), (Comparable)Integer.valueOf(1024));
    private final String hash;
    private int size = (Integer)IMAGE_LENGTH_RANGE.lowerEndpoint();
    private GravatarQrImageType imageType = GravatarQrImageType.Default;
    private GravatarQrImageVersion version = GravatarQrImageVersion.Blank;

    private GravatarQrCodeRequest(String hash) {
        this.hash = hash;
    }

    public static GravatarQrCodeRequest fromEmail(String email) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkArgument((!email.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)InputValidator.isValidEmailAddress(email));
        String hash = Hasher.SHA256.hash(email);
        return new GravatarQrCodeRequest(hash);
    }

    public static GravatarQrCodeRequest fromHash(String hash) {
        Preconditions.checkNotNull((Object)hash);
        Preconditions.checkArgument((!hash.trim().isEmpty() ? 1 : 0) != 0);
        return new GravatarQrCodeRequest(hash);
    }

    public String getHash() {
        return this.hash;
    }

    @CanIgnoreReturnValue
    public GravatarQrCodeRequest setSize(int imageLength) {
        Preconditions.checkArgument((boolean)IMAGE_LENGTH_RANGE.contains((Comparable)Integer.valueOf(imageLength)));
        this.size = imageLength;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    @CanIgnoreReturnValue
    public GravatarQrCodeRequest setImageType(GravatarQrImageType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        this.imageType = type;
        return this;
    }

    public GravatarQrImageType getImageType() {
        return this.imageType;
    }

    @CanIgnoreReturnValue
    public GravatarQrCodeRequest setVersion(GravatarQrImageVersion version) {
        Preconditions.checkNotNull((Object)((Object)version));
        this.version = version;
        return this;
    }

    public GravatarQrImageVersion getVersion() {
        return this.version;
    }

    public String getRequestUrl() {
        return BASE_URL + this.hash + ".qr" + this.imageType.getAsUrlParameter(true) + this.version.getAsUrlParameter(false) + "&size=" + this.size;
    }

    public BufferedImage getBufferedImage() {
        try {
            String url = this.getRequestUrl();
            return ImageIO.read(URI.create(url).toURL());
        }
        catch (IOException e) {
            throw new GravatarJavaClientException(e);
        }
    }

    @CanIgnoreReturnValue
    public boolean saveTo(File saveTo) {
        Preconditions.checkNotNull((Object)saveTo);
        Preconditions.checkArgument((!saveTo.isDirectory() ? 1 : 0) != 0);
        Preconditions.checkArgument((!saveTo.exists() ? 1 : 0) != 0);
        return GravatarRequestImageSaver.INSTANCE.saveTo(this.getBufferedImage(), saveTo, "png");
    }

    public int hashCode() {
        int ret = this.hash.hashCode();
        ret = 31 * ret + Integer.hashCode(this.size);
        ret = 31 * ret + this.imageType.hashCode();
        ret = 31 * ret + this.version.hashCode();
        return ret;
    }

    public String toString() {
        return "GravatarQrCodeRequest{hash=\"" + this.hash + "\", size=" + this.size + ", imageType=" + String.valueOf((Object)this.imageType) + ", version=" + String.valueOf((Object)this.version) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarQrCodeRequest)) {
            return false;
        }
        GravatarQrCodeRequest other = (GravatarQrCodeRequest)o;
        return other.hash.equals(this.hash) && other.version == this.version && other.imageType == this.imageType && other.size == this.size;
    }
}

