/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile.serialization;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import java.time.Instant;

@Immutable
public final class GravatarProfileRequestResult {
    private final Instant requestInstant;
    private final boolean succeeded;

    public GravatarProfileRequestResult(Instant requestInstant, boolean succeeded) {
        Preconditions.checkNotNull((Object)requestInstant);
        this.requestInstant = requestInstant;
        this.succeeded = succeeded;
    }

    public Instant getRequestInstant() {
        return this.requestInstant;
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    public boolean failed() {
        return !this.succeeded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarProfileRequestResult)) {
            return false;
        }
        GravatarProfileRequestResult other = (GravatarProfileRequestResult)o;
        return this.succeeded == other.succeeded && this.requestInstant.equals(other.requestInstant);
    }

    public int hashCode() {
        int ret = this.requestInstant.hashCode();
        ret = 31 * ret + (this.succeeded ? 1 : 0);
        return ret;
    }

    public String toString() {
        return "GravatarProfileRequestResult{requestInstant=" + String.valueOf(this.requestInstant) + ", succeeded=" + this.succeeded + "}";
    }
}

