/*
 * Decompiled with CFR 0.152.
 */
package com.github.natche.gravatarjavaclient.profile;

import com.github.natche.gravatarjavaclient.exceptions.GravatarJavaClientException;
import com.github.natche.gravatarjavaclient.profile.GravatarProfileRequestHandler;
import com.github.natche.gravatarjavaclient.profile.gson.GsonProvider;
import com.github.natche.gravatarjavaclient.profile.serialization.GravatarProfile;
import com.github.natche.gravatarjavaclient.utils.Hasher;
import com.github.natche.gravatarjavaclient.utils.InputValidator;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;

public final class GravatarProfileRequest {
    private static final int TOKEN_SUBSTRING_LENGTH = 5;
    private final String hashOrId;
    private String token;

    private GravatarProfileRequest(String hashOrId) {
        this.hashOrId = hashOrId;
    }

    public static GravatarProfileRequest from(String id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((!id.trim().isEmpty() ? 1 : 0) != 0);
        return new GravatarProfileRequest(id);
    }

    public static GravatarProfileRequest fromEmail(String email) {
        Preconditions.checkNotNull((Object)email);
        Preconditions.checkArgument((!email.trim().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)InputValidator.isValidEmailAddress(email));
        return new GravatarProfileRequest(Hasher.SHA256.hash(email));
    }

    public GravatarProfileRequest setToken(String token) {
        Preconditions.checkNotNull((Object)token);
        Preconditions.checkArgument((!token.trim().isEmpty() ? 1 : 0) != 0);
        this.token = token;
        return this;
    }

    public String getHashOrId() {
        return this.hashOrId;
    }

    public GravatarProfile getProfile() {
        return GravatarProfileRequestHandler.INSTANCE.getProfile(this.token, this.hashOrId);
    }

    @CanIgnoreReturnValue
    public boolean writeToFile(File file) {
        return this.writeToFile(GsonProvider.INSTANCE.get(), file);
    }

    @CanIgnoreReturnValue
    public boolean writeToFile(Gson serializer, File file) {
        boolean bl;
        Preconditions.checkNotNull((Object)serializer);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkArgument((!file.isDirectory() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)file.exists());
        Preconditions.checkArgument((boolean)InputValidator.isValidFilename(file.getName()));
        FileWriter writer = new FileWriter(file);
        try {
            serializer.toJson((Object)this.getProfile(), (Appendable)writer);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new GravatarJavaClientException(e);
            }
        }
        writer.close();
        return bl;
    }

    public int hashCode() {
        int ret = this.hashOrId.hashCode();
        if (this.token != null) {
            ret = 31 * ret + this.token.hashCode();
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GravatarProfileRequest)) {
            return false;
        }
        GravatarProfileRequest other = (GravatarProfileRequest)o;
        return this.hashOrId.equals(other.hashOrId) && this.token.equals(other.token);
    }

    public String toString() {
        String sub = this.token != null && this.token.length() > 5 ? this.token.substring(0, 5) + "..." : this.token;
        return "GravatarProfileRequest{hash=\"" + this.hashOrId + "\", token=" + sub + "}";
    }
}

