/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.factory;

import java.lang.reflect.Constructor;
import org.graphwalker.core.condition.ReachedStopCondition;
import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.core.generator.PathGenerator;
import org.graphwalker.java.annotation.GraphWalker;
import org.graphwalker.java.factory.StopConditionFactory;
import org.graphwalker.java.test.TestExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PathGeneratorFactory {
    private static final Logger logger = LoggerFactory.getLogger(PathGeneratorFactory.class);

    public static PathGenerator createPathGenerator(GraphWalker annotation) {
        try {
            Constructor<? extends PathGenerator> constructor;
            try {
                constructor = annotation.pathGenerator().getConstructor(StopCondition.class);
            }
            catch (Throwable t) {
                logger.error(t.getMessage());
                constructor = annotation.pathGenerator().getConstructor(ReachedStopCondition.class);
            }
            if (constructor == null) {
                throw new TestExecutionException("Couldn't find a valid constructor");
            }
            return constructor.newInstance(StopConditionFactory.createStopCondition(annotation));
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
            throw new TestExecutionException(e);
        }
    }
}

