/*
 * Decompiled with CFR 0.152.
 */
package org.graphwalker.java.factory;

import org.graphwalker.core.condition.StopCondition;
import org.graphwalker.java.annotation.GraphWalker;
import org.graphwalker.java.test.TestExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StopConditionFactory {
    private static final Logger logger = LoggerFactory.getLogger(StopConditionFactory.class);

    public static StopCondition createStopCondition(GraphWalker annotation) {
        String value = annotation.stopConditionValue();
        Class<? extends StopCondition> stopCondition = annotation.stopCondition();
        if (value.isEmpty()) {
            try {
                return stopCondition.newInstance();
            }
            catch (Throwable t) {
                logger.error(t.getMessage());
            }
        }
        try {
            return stopCondition.getConstructor(String.class).newInstance(value);
        }
        catch (Throwable t) {
            logger.error(t.getMessage());
            try {
                return stopCondition.getConstructor(Long.TYPE).newInstance(Long.parseLong(value));
            }
            catch (Throwable t2) {
                logger.error(t2.getMessage());
                try {
                    return stopCondition.getConstructor(Integer.TYPE).newInstance(Integer.parseInt(value));
                }
                catch (Throwable t3) {
                    logger.error(t3.getMessage());
                    try {
                        return stopCondition.getConstructor(Double.TYPE).newInstance(Double.parseDouble(value));
                    }
                    catch (Throwable t4) {
                        logger.error(t4.getMessage());
                        try {
                            return stopCondition.getConstructor(Float.TYPE).newInstance(Float.valueOf(Float.parseFloat(value)));
                        }
                        catch (Throwable t5) {
                            logger.error(t5.getMessage());
                            throw new TestExecutionException();
                        }
                    }
                }
            }
        }
    }
}

