/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.manager;

import com.kraken.api.javawrapper.properties.KrakenProperties;
import com.kraken.api.javawrapper.rest.client.MarketDataClient;
import com.kraken.api.javawrapper.rest.client.RestClient;
import com.kraken.api.javawrapper.rest.client.WebSocketsAuthenticationClient;
import com.kraken.api.javawrapper.rest.enums.RestEnumerations;
import com.kraken.api.javawrapper.rest.requestinterceptor.KrakenRequestInterceptor;
import com.kraken.api.javawrapper.websocket.client.KrakenPrivateWebSocketClient;
import com.kraken.api.javawrapper.websocket.client.KrakenPublicWebSocketClient;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;

public final class KrakenConnectionManager {
    private final String apiKey;
    private final String privateKey;

    public KrakenConnectionManager(String apiKey, String privateKey) {
        this.apiKey = apiKey;
        this.privateKey = privateKey;
    }

    public <T extends RestClient> T getRestClient(Class<T> tClass) {
        return (T)((RestClient)Feign.builder().client((Client)new OkHttpClient()).decoder((Decoder)new JacksonDecoder(KrakenProperties.OBJECT_MAPPER)).encoder((Encoder)new JacksonEncoder(KrakenProperties.OBJECT_MAPPER)).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.FULL).requestInterceptor((RequestInterceptor)new KrakenRequestInterceptor(this.apiKey, this.privateKey)).target(tClass, "https://api.kraken.com/0"));
    }

    public KrakenPrivateWebSocketClient getKrakenPrivateWebSocketClient() {
        MarketDataClient marketDataClient = this.getRestClient(RestEnumerations.Endpoint.MARKET_DATA);
        WebSocketsAuthenticationClient webSocketsAuthenticationClient = this.getRestClient(RestEnumerations.Endpoint.WEBSOCKETS_AUTHENTICATION);
        return new KrakenPrivateWebSocketClient(marketDataClient, webSocketsAuthenticationClient);
    }

    public KrakenPublicWebSocketClient getKrakenPublicWebSocketClient() {
        MarketDataClient marketDataClient = this.getRestClient(RestEnumerations.Endpoint.MARKET_DATA);
        return new KrakenPublicWebSocketClient(marketDataClient);
    }
}

