/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.rest.requestinterceptor;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class KrakenRequestInterceptor
implements RequestInterceptor {
    private static final String SHA256_ALGORITHM = "SHA-256";
    private static final String HMAC_ALGORITHM = "HmacSHA512";
    private final String apiKey;
    private final String privateKey;

    public KrakenRequestInterceptor(String apiKey, String privateKey) {
        this.apiKey = apiKey;
        this.privateKey = privateKey;
    }

    public void apply(RequestTemplate requestTemplate) {
        String signature;
        if (Objects.isNull(this.apiKey) || Objects.isNull(this.privateKey)) {
            return;
        }
        long nonce = System.currentTimeMillis();
        String nonceAsParam = "nonce=" + nonce;
        byte[] body = requestTemplate.body();
        if (Objects.isNull(body)) {
            return;
        }
        Charset charset = requestTemplate.requestCharset();
        Object bodyString = new String(body, charset);
        bodyString = ObjectUtils.isEmpty((Object)bodyString) ? nonceAsParam : nonceAsParam + "&" + (String)bodyString;
        requestTemplate.body((String)bodyString);
        try {
            MessageDigest digestSHA256 = MessageDigest.getInstance(SHA256_ALGORITHM);
            byte[] toBeEncrypted = ArrayUtils.addAll((byte[])requestTemplate.path().getBytes(charset), (byte[])digestSHA256.digest((nonce + (String)bodyString).getBytes(charset)));
            SecretKeySpec secretKeySpec = new SecretKeySpec(Base64.decodeBase64((String)this.privateKey), HMAC_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_ALGORITHM);
            mac.init(secretKeySpec);
            signature = Base64.encodeBase64String((byte[])mac.doFinal(toBeEncrypted));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        requestTemplate.header("API-Key", new String[]{this.apiKey});
        requestTemplate.header("API-Sign", new String[]{signature});
    }
}

