/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.websocket.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.kraken.api.javawrapper.properties.KrakenProperties;
import com.kraken.api.javawrapper.rest.client.MarketDataClient;
import com.kraken.api.javawrapper.websocket.dto.request.RequestIdentifier;
import com.kraken.api.javawrapper.websocket.model.message.AbstractMessage;
import com.kraken.api.javawrapper.websocket.model.message.AbstractPublicationMessage;
import com.kraken.api.javawrapper.websocket.model.message.HeartbeatMessage;
import com.kraken.api.javawrapper.websocket.model.message.StatusMessage;
import com.kraken.api.javawrapper.websocket.model.method.AbstractRequest;
import com.kraken.api.javawrapper.websocket.model.method.AbstractResponse;
import com.kraken.api.javawrapper.websocket.model.method.Echo;
import com.kraken.api.javawrapper.websocket.model.method.Interaction;
import com.kraken.api.javawrapper.websocket.model.method.Subscription;
import com.kraken.api.javawrapper.websocket.model.method.Unsubscription;
import com.kraken.api.javawrapper.websocket.utils.RandomUtils;
import com.kraken.api.javawrapper.websocket.utils.WebSocketTrafficGateway;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.ReplaySubject;
import java.math.BigInteger;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KrakenBaseWebSocketClient
extends WebSocketClient {
    private static final Logger log = LoggerFactory.getLogger(KrakenBaseWebSocketClient.class);
    private final WebSocketTrafficGateway webSocketTrafficGateway = new WebSocketTrafficGateway();
    private final MarketDataClient marketDataClient;

    public KrakenBaseWebSocketClient(URI krakenWebSocketUrl, MarketDataClient marketDataClient) {
        super(krakenWebSocketUrl);
        this.marketDataClient = marketDataClient;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        log.trace("Connection opened with status: {}", (Object)serverHandshake.getHttpStatusMessage());
    }

    public void onMessage(String s) {
        log.trace("Received message: {}", (Object)s);
        AbstractResponse abstractResponse = null;
        AbstractMessage abstractMessage = null;
        boolean isResponse = false;
        boolean isMessage = false;
        try {
            abstractResponse = (AbstractResponse)KrakenProperties.OBJECT_MAPPER.readValue(s, AbstractResponse.class);
            isResponse = true;
        }
        catch (JsonProcessingException e) {
            log.trace("Received message is not an AbstractResponse. {}", (Object)e.getLocalizedMessage());
        }
        if (isResponse) {
            Interaction.AbstractInteractionResponse interactionResponse;
            if (abstractResponse instanceof Interaction.AbstractInteractionResponse && !(interactionResponse = (Interaction.AbstractInteractionResponse)abstractResponse).getSuccess().booleanValue()) {
                log.error(interactionResponse.getError());
                this.webSocketTrafficGateway.removeErrorRequest(abstractResponse);
            } else {
                this.webSocketTrafficGateway.responseReply(abstractResponse);
                if (abstractResponse instanceof Unsubscription.UnsubscribeResponse) {
                    Unsubscription.UnsubscribeResponse unsubscribeResponse = (Unsubscription.UnsubscribeResponse)abstractResponse;
                    this.webSocketTrafficGateway.unsubscribeRequest(unsubscribeResponse);
                }
            }
        } else {
            try {
                abstractMessage = (AbstractMessage)KrakenProperties.OBJECT_MAPPER.readValue(s, AbstractMessage.class);
                isMessage = true;
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException("Received message is of unknown type. " + ex.getMessage());
            }
        }
        if (isMessage) {
            if (abstractMessage instanceof HeartbeatMessage) {
                HeartbeatMessage heartbeatMessage = (HeartbeatMessage)abstractMessage;
            } else if (abstractMessage instanceof StatusMessage) {
                StatusMessage statusMessage = (StatusMessage)abstractMessage;
                this.webSocketTrafficGateway.responseAnnounce(statusMessage);
            } else {
                AbstractPublicationMessage publicationMessage = (AbstractPublicationMessage)abstractMessage;
                this.webSocketTrafficGateway.publishMessage(publicationMessage);
            }
        }
        if (Objects.nonNull(abstractResponse)) {
            log.trace("Response class: {}", (Object)abstractResponse);
        }
        if (Objects.nonNull(abstractMessage)) {
            log.trace("Message class: {}", (Object)abstractMessage);
        }
    }

    public void onClose(int i, String s, boolean b) {
        log.trace("Connection closed. i: {}, s: {}, b: {}", new Object[]{i, s, b});
    }

    public void onError(Exception e) {
        log.error("Unexpected error during websocket operation: {}", (Object)e.getMessage());
        throw new RuntimeException(e);
    }

    public Single<Echo.PongResponse> ping() {
        return this.ping(new Echo.PingRequest());
    }

    public Single<Echo.PongResponse> ping(Echo.PingRequest pingRequest) {
        if (Objects.isNull(pingRequest.getRequestId())) {
            pingRequest.setRequestId(this.generateRandomReqId());
        }
        ZonedDateTime serverTime = this.marketDataClient.getServerTime().getResult().getIsoTime();
        RequestIdentifier requestIdentifier = pingRequest.toRequestIdentifier(serverTime);
        ReplaySubject pongMessageReplaySubject = ReplaySubject.create();
        this.webSocketTrafficGateway.registerRequest(requestIdentifier, pongMessageReplaySubject);
        this.sendPayload(pingRequest, serverTime);
        return pongMessageReplaySubject.firstOrError();
    }

    public List<Single<Subscription.SubscribeResponse>> subscribe(Subscription.SubscribeRequest subscribeRequest) {
        if (Objects.isNull(subscribeRequest.getRequestId())) {
            subscribeRequest.setRequestId(this.generateRandomReqId());
        }
        ZonedDateTime serverTime = this.marketDataClient.getServerTime().getResult().getIsoTime();
        List<RequestIdentifier> requestIdentifiers = subscribeRequest.toRequestIdentifiers(serverTime);
        ArrayList<Single<Subscription.SubscribeResponse>> list = new ArrayList<Single<Subscription.SubscribeResponse>>();
        for (RequestIdentifier requestIdentifier : requestIdentifiers) {
            ReplaySubject subscribeResponseReplaySubject = ReplaySubject.create((int)1);
            this.webSocketTrafficGateway.registerRequest(requestIdentifier, subscribeResponseReplaySubject);
            RequestIdentifier publicationRequestIdentifier = requestIdentifier.duplicate();
            PublishSubject<AbstractPublicationMessage> publicationMessagePublishSubject = this.webSocketTrafficGateway.subscribePublication(publicationRequestIdentifier);
            Single subscribeResponseSingle = this.webSocketTrafficGateway.retrieveResponse(requestIdentifier);
            subscribeResponseSingle = subscribeResponseSingle.map(e -> {
                e.setPublicationMessagePublishSubject(publicationMessagePublishSubject);
                return e;
            });
            list.add((Single<Subscription.SubscribeResponse>)subscribeResponseSingle);
        }
        this.sendPayload(subscribeRequest, serverTime);
        return list;
    }

    public List<Single<Unsubscription.UnsubscribeResponse>> unsubscribe(Unsubscription.UnsubscribeRequest unsubscribeRequest) {
        if (Objects.isNull(unsubscribeRequest.getRequestId())) {
            unsubscribeRequest.setRequestId(this.generateRandomReqId());
        }
        ZonedDateTime serverTime = this.marketDataClient.getServerTime().getResult().getIsoTime();
        List<RequestIdentifier> unsubscribeRequestIdentifiers = unsubscribeRequest.toRequestIdentifiers(serverTime);
        ArrayList<Single<Unsubscription.UnsubscribeResponse>> list = new ArrayList<Single<Unsubscription.UnsubscribeResponse>>();
        for (RequestIdentifier requestIdentifier : unsubscribeRequestIdentifiers) {
            ReplaySubject unsubscribeResponseSubject = ReplaySubject.create();
            this.webSocketTrafficGateway.registerRequest(requestIdentifier, unsubscribeResponseSubject);
            RequestIdentifier publicationRequestIdentifier = requestIdentifier.duplicate();
            PublishSubject<AbstractPublicationMessage> publicationMessagePublishSubject = this.webSocketTrafficGateway.subscribePublication(publicationRequestIdentifier);
            Single unsubscribeResponseSingle = this.webSocketTrafficGateway.retrieveResponse(requestIdentifier);
            unsubscribeResponseSingle = unsubscribeResponseSingle.map(e -> {
                e.setPublicationMessagePublishSubject(publicationMessagePublishSubject);
                return e;
            });
            list.add((Single<Unsubscription.UnsubscribeResponse>)unsubscribeResponseSingle);
        }
        this.sendPayload(unsubscribeRequest, serverTime);
        return list;
    }

    public void addOrder() {
    }

    public void editOrder() {
    }

    public void cancelOrder() {
    }

    public void cancelAllOrders() {
    }

    public void cancelAllOrdersAfter() {
    }

    private <T extends AbstractRequest> void sendPayload(T request, ZonedDateTime timestamp) {
        String requestAsJson;
        try {
            requestAsJson = KrakenProperties.OBJECT_MAPPER.writeValueAsString(request);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.send(requestAsJson);
        log.trace("Subscription payload sent at: {}", (Object)timestamp);
    }

    private BigInteger generateRandomReqId() {
        return RandomUtils.nextBigInteger(KrakenProperties.KRAKEN_REQ_ID_MAX_LIMIT);
    }

    public WebSocketTrafficGateway getWebSocketTrafficGateway() {
        return this.webSocketTrafficGateway;
    }

    public MarketDataClient getMarketDataClient() {
        return this.marketDataClient;
    }
}

