/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.websocket.model.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.kraken.api.javawrapper.websocket.dto.request.RequestIdentifier;
import com.kraken.api.javawrapper.websocket.model.message.AbstractPublicationMessage;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.NonNull;

@JsonDeserialize(builder=BookMessageBuilderImpl.class)
public class BookMessage
extends AbstractPublicationMessage {
    private List<Book> data;

    @Override
    public RequestIdentifier toRequestIdentifier() {
        return super.toRequestIdentifier().toBuilder().symbol(this.data.get((int)0).symbol).build();
    }

    protected BookMessage(BookMessageBuilder<?, ?> b) {
        super((AbstractPublicationMessage.AbstractPublicationMessageBuilder<?, ?>)b);
        this.setChannel("book");
        this.data = b.data;
    }

    public static BookMessageBuilder<?, ?> builder() {
        return new BookMessageBuilderImpl();
    }

    public List<Book> getData() {
        return this.data;
    }

    public void setData(List<Book> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "BookMessage(data=" + String.valueOf(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookMessage)) {
            return false;
        }
        BookMessage other = (BookMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Book> this$data = this.getData();
        List<Book> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BookMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Book> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public BookMessage(List<Book> data) {
        this.setChannel("book");
        this.data = data;
    }

    public BookMessage() {
        this.setChannel("book");
    }

    public static class Book {
        @NonNull
        private List<BookEntry> asks;
        @NonNull
        private List<BookEntry> bids;
        @NonNull
        private Long checksum;
        @NonNull
        private String symbol;
        @NonNull
        private ZonedDateTime timestamp;

        @NonNull
        public List<BookEntry> getAsks() {
            return this.asks;
        }

        @NonNull
        public List<BookEntry> getBids() {
            return this.bids;
        }

        @NonNull
        public Long getChecksum() {
            return this.checksum;
        }

        @NonNull
        public String getSymbol() {
            return this.symbol;
        }

        @NonNull
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        public void setAsks(@NonNull List<BookEntry> asks) {
            if (asks == null) {
                throw new NullPointerException("asks is marked non-null but is null");
            }
            this.asks = asks;
        }

        public void setBids(@NonNull List<BookEntry> bids) {
            if (bids == null) {
                throw new NullPointerException("bids is marked non-null but is null");
            }
            this.bids = bids;
        }

        public void setChecksum(@NonNull Long checksum) {
            if (checksum == null) {
                throw new NullPointerException("checksum is marked non-null but is null");
            }
            this.checksum = checksum;
        }

        public void setSymbol(@NonNull String symbol) {
            if (symbol == null) {
                throw new NullPointerException("symbol is marked non-null but is null");
            }
            this.symbol = symbol;
        }

        public void setTimestamp(@NonNull ZonedDateTime timestamp) {
            if (timestamp == null) {
                throw new NullPointerException("timestamp is marked non-null but is null");
            }
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Book)) {
                return false;
            }
            Book other = (Book)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$checksum = this.getChecksum();
            Long other$checksum = other.getChecksum();
            if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
                return false;
            }
            List<BookEntry> this$asks = this.getAsks();
            List<BookEntry> other$asks = other.getAsks();
            if (this$asks == null ? other$asks != null : !((Object)this$asks).equals(other$asks)) {
                return false;
            }
            List<BookEntry> this$bids = this.getBids();
            List<BookEntry> other$bids = other.getBids();
            if (this$bids == null ? other$bids != null : !((Object)this$bids).equals(other$bids)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                return false;
            }
            ZonedDateTime this$timestamp = this.getTimestamp();
            ZonedDateTime other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Book;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
            List<BookEntry> $asks = this.getAsks();
            result = result * 59 + ($asks == null ? 43 : ((Object)$asks).hashCode());
            List<BookEntry> $bids = this.getBids();
            result = result * 59 + ($bids == null ? 43 : ((Object)$bids).hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            ZonedDateTime $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            return result;
        }

        public String toString() {
            return "BookMessage.Book(asks=" + String.valueOf(this.getAsks()) + ", bids=" + String.valueOf(this.getBids()) + ", checksum=" + this.getChecksum() + ", symbol=" + this.getSymbol() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ")";
        }

        public static class BookEntry {
            @NonNull
            private BigDecimal price;
            @JsonProperty(value="qty", required=true)
            private BigDecimal quantity;

            @NonNull
            public BigDecimal getPrice() {
                return this.price;
            }

            public BigDecimal getQuantity() {
                return this.quantity;
            }

            public void setPrice(@NonNull BigDecimal price) {
                if (price == null) {
                    throw new NullPointerException("price is marked non-null but is null");
                }
                this.price = price;
            }

            @JsonProperty(value="qty", required=true)
            public void setQuantity(BigDecimal quantity) {
                this.quantity = quantity;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BookEntry)) {
                    return false;
                }
                BookEntry other = (BookEntry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BigDecimal this$price = this.getPrice();
                BigDecimal other$price = other.getPrice();
                if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
                    return false;
                }
                BigDecimal this$quantity = this.getQuantity();
                BigDecimal other$quantity = other.getQuantity();
                return !(this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity));
            }

            protected boolean canEqual(Object other) {
                return other instanceof BookEntry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BigDecimal $price = this.getPrice();
                result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
                BigDecimal $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                return result;
            }

            public String toString() {
                return "BookMessage.Book.BookEntry(price=" + String.valueOf(this.getPrice()) + ", quantity=" + String.valueOf(this.getQuantity()) + ")";
            }
        }
    }

    public static abstract class BookMessageBuilder<C extends BookMessage, B extends BookMessageBuilder<C, B>>
    extends AbstractPublicationMessage.AbstractPublicationMessageBuilder<C, B> {
        private List<Book> data;

        public B data(List<Book> data) {
            this.data = data;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "BookMessage.BookMessageBuilder(super=" + super.toString() + ", data=" + String.valueOf(this.data) + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class BookMessageBuilderImpl
    extends BookMessageBuilder<BookMessage, BookMessageBuilderImpl> {
        private BookMessageBuilderImpl() {
        }

        @Override
        protected BookMessageBuilderImpl self() {
            return this;
        }

        @Override
        public BookMessage build() {
            return new BookMessage(this);
        }
    }
}

