/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.websocket.model.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.kraken.api.javawrapper.websocket.dto.request.RequestIdentifier;
import com.kraken.api.javawrapper.websocket.model.message.AbstractPublicationMessage;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.NonNull;

@JsonDeserialize(builder=OHLCMessageBuilderImpl.class)
public class OHLCMessage
extends AbstractPublicationMessage {
    private List<OHLC> data;
    private ZonedDateTime timestamp;

    @Override
    public RequestIdentifier toRequestIdentifier() {
        return super.toRequestIdentifier().toBuilder().symbol(this.data.get((int)0).symbol).build();
    }

    protected OHLCMessage(OHLCMessageBuilder<?, ?> b) {
        super((AbstractPublicationMessage.AbstractPublicationMessageBuilder<?, ?>)b);
        this.setChannel("ohlc");
        this.data = b.data;
        this.timestamp = b.timestamp;
    }

    public static OHLCMessageBuilder<?, ?> builder() {
        return new OHLCMessageBuilderImpl();
    }

    public List<OHLC> getData() {
        return this.data;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setData(List<OHLC> data) {
        this.data = data;
    }

    public void setTimestamp(ZonedDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "OHLCMessage(data=" + String.valueOf(this.getData()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OHLCMessage)) {
            return false;
        }
        OHLCMessage other = (OHLCMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<OHLC> this$data = this.getData();
        List<OHLC> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        ZonedDateTime this$timestamp = this.getTimestamp();
        ZonedDateTime other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OHLCMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<OHLC> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        ZonedDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public OHLCMessage(List<OHLC> data, ZonedDateTime timestamp) {
        this.setChannel("ohlc");
        this.data = data;
        this.timestamp = timestamp;
    }

    public OHLCMessage() {
        this.setChannel("ohlc");
    }

    public static class OHLC {
        @NonNull
        private BigDecimal close;
        @NonNull
        private BigDecimal high;
        @NonNull
        private BigDecimal low;
        @NonNull
        private BigDecimal open;
        @NonNull
        private String symbol;
        @JsonProperty(value="interval_begin", required=true)
        private ZonedDateTime intervalBegin;
        @NonNull
        private Integer trades;
        @NonNull
        private BigDecimal volume;
        @NonNull
        private BigDecimal vwap;
        @NonNull
        private BigDecimal interval;
        @NonNull
        private ZonedDateTime timestamp;

        @NonNull
        public BigDecimal getClose() {
            return this.close;
        }

        @NonNull
        public BigDecimal getHigh() {
            return this.high;
        }

        @NonNull
        public BigDecimal getLow() {
            return this.low;
        }

        @NonNull
        public BigDecimal getOpen() {
            return this.open;
        }

        @NonNull
        public String getSymbol() {
            return this.symbol;
        }

        public ZonedDateTime getIntervalBegin() {
            return this.intervalBegin;
        }

        @NonNull
        public Integer getTrades() {
            return this.trades;
        }

        @NonNull
        public BigDecimal getVolume() {
            return this.volume;
        }

        @NonNull
        public BigDecimal getVwap() {
            return this.vwap;
        }

        @NonNull
        public BigDecimal getInterval() {
            return this.interval;
        }

        @NonNull
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        public void setClose(@NonNull BigDecimal close) {
            if (close == null) {
                throw new NullPointerException("close is marked non-null but is null");
            }
            this.close = close;
        }

        public void setHigh(@NonNull BigDecimal high) {
            if (high == null) {
                throw new NullPointerException("high is marked non-null but is null");
            }
            this.high = high;
        }

        public void setLow(@NonNull BigDecimal low) {
            if (low == null) {
                throw new NullPointerException("low is marked non-null but is null");
            }
            this.low = low;
        }

        public void setOpen(@NonNull BigDecimal open) {
            if (open == null) {
                throw new NullPointerException("open is marked non-null but is null");
            }
            this.open = open;
        }

        public void setSymbol(@NonNull String symbol) {
            if (symbol == null) {
                throw new NullPointerException("symbol is marked non-null but is null");
            }
            this.symbol = symbol;
        }

        @JsonProperty(value="interval_begin", required=true)
        public void setIntervalBegin(ZonedDateTime intervalBegin) {
            this.intervalBegin = intervalBegin;
        }

        public void setTrades(@NonNull Integer trades) {
            if (trades == null) {
                throw new NullPointerException("trades is marked non-null but is null");
            }
            this.trades = trades;
        }

        public void setVolume(@NonNull BigDecimal volume) {
            if (volume == null) {
                throw new NullPointerException("volume is marked non-null but is null");
            }
            this.volume = volume;
        }

        public void setVwap(@NonNull BigDecimal vwap) {
            if (vwap == null) {
                throw new NullPointerException("vwap is marked non-null but is null");
            }
            this.vwap = vwap;
        }

        public void setInterval(@NonNull BigDecimal interval) {
            if (interval == null) {
                throw new NullPointerException("interval is marked non-null but is null");
            }
            this.interval = interval;
        }

        public void setTimestamp(@NonNull ZonedDateTime timestamp) {
            if (timestamp == null) {
                throw new NullPointerException("timestamp is marked non-null but is null");
            }
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OHLC)) {
                return false;
            }
            OHLC other = (OHLC)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$trades = this.getTrades();
            Integer other$trades = other.getTrades();
            if (this$trades == null ? other$trades != null : !((Object)this$trades).equals(other$trades)) {
                return false;
            }
            BigDecimal this$close = this.getClose();
            BigDecimal other$close = other.getClose();
            if (this$close == null ? other$close != null : !((Object)this$close).equals(other$close)) {
                return false;
            }
            BigDecimal this$high = this.getHigh();
            BigDecimal other$high = other.getHigh();
            if (this$high == null ? other$high != null : !((Object)this$high).equals(other$high)) {
                return false;
            }
            BigDecimal this$low = this.getLow();
            BigDecimal other$low = other.getLow();
            if (this$low == null ? other$low != null : !((Object)this$low).equals(other$low)) {
                return false;
            }
            BigDecimal this$open = this.getOpen();
            BigDecimal other$open = other.getOpen();
            if (this$open == null ? other$open != null : !((Object)this$open).equals(other$open)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                return false;
            }
            ZonedDateTime this$intervalBegin = this.getIntervalBegin();
            ZonedDateTime other$intervalBegin = other.getIntervalBegin();
            if (this$intervalBegin == null ? other$intervalBegin != null : !((Object)this$intervalBegin).equals(other$intervalBegin)) {
                return false;
            }
            BigDecimal this$volume = this.getVolume();
            BigDecimal other$volume = other.getVolume();
            if (this$volume == null ? other$volume != null : !((Object)this$volume).equals(other$volume)) {
                return false;
            }
            BigDecimal this$vwap = this.getVwap();
            BigDecimal other$vwap = other.getVwap();
            if (this$vwap == null ? other$vwap != null : !((Object)this$vwap).equals(other$vwap)) {
                return false;
            }
            BigDecimal this$interval = this.getInterval();
            BigDecimal other$interval = other.getInterval();
            if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
                return false;
            }
            ZonedDateTime this$timestamp = this.getTimestamp();
            ZonedDateTime other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OHLC;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $trades = this.getTrades();
            result = result * 59 + ($trades == null ? 43 : ((Object)$trades).hashCode());
            BigDecimal $close = this.getClose();
            result = result * 59 + ($close == null ? 43 : ((Object)$close).hashCode());
            BigDecimal $high = this.getHigh();
            result = result * 59 + ($high == null ? 43 : ((Object)$high).hashCode());
            BigDecimal $low = this.getLow();
            result = result * 59 + ($low == null ? 43 : ((Object)$low).hashCode());
            BigDecimal $open = this.getOpen();
            result = result * 59 + ($open == null ? 43 : ((Object)$open).hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            ZonedDateTime $intervalBegin = this.getIntervalBegin();
            result = result * 59 + ($intervalBegin == null ? 43 : ((Object)$intervalBegin).hashCode());
            BigDecimal $volume = this.getVolume();
            result = result * 59 + ($volume == null ? 43 : ((Object)$volume).hashCode());
            BigDecimal $vwap = this.getVwap();
            result = result * 59 + ($vwap == null ? 43 : ((Object)$vwap).hashCode());
            BigDecimal $interval = this.getInterval();
            result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
            ZonedDateTime $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            return result;
        }

        public String toString() {
            return "OHLCMessage.OHLC(close=" + String.valueOf(this.getClose()) + ", high=" + String.valueOf(this.getHigh()) + ", low=" + String.valueOf(this.getLow()) + ", open=" + String.valueOf(this.getOpen()) + ", symbol=" + this.getSymbol() + ", intervalBegin=" + String.valueOf(this.getIntervalBegin()) + ", trades=" + this.getTrades() + ", volume=" + String.valueOf(this.getVolume()) + ", vwap=" + String.valueOf(this.getVwap()) + ", interval=" + String.valueOf(this.getInterval()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ")";
        }
    }

    public static abstract class OHLCMessageBuilder<C extends OHLCMessage, B extends OHLCMessageBuilder<C, B>>
    extends AbstractPublicationMessage.AbstractPublicationMessageBuilder<C, B> {
        private List<OHLC> data;
        private ZonedDateTime timestamp;

        public B data(List<OHLC> data) {
            this.data = data;
            return (B)this.self();
        }

        public B timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "OHLCMessage.OHLCMessageBuilder(super=" + super.toString() + ", data=" + String.valueOf(this.data) + ", timestamp=" + String.valueOf(this.timestamp) + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class OHLCMessageBuilderImpl
    extends OHLCMessageBuilder<OHLCMessage, OHLCMessageBuilderImpl> {
        private OHLCMessageBuilderImpl() {
        }

        @Override
        protected OHLCMessageBuilderImpl self() {
            return this;
        }

        @Override
        public OHLCMessage build() {
            return new OHLCMessage(this);
        }
    }
}

