/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.websocket.model.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.kraken.api.javawrapper.websocket.dto.request.RequestIdentifier;
import com.kraken.api.javawrapper.websocket.model.message.AbstractPublicationMessage;
import java.math.BigDecimal;
import java.util.List;
import lombok.NonNull;

@JsonDeserialize(builder=TickerMessageBuilderImpl.class)
public class TickerMessage
extends AbstractPublicationMessage {
    private List<Ticker> data;

    @Override
    public RequestIdentifier toRequestIdentifier() {
        return super.toRequestIdentifier().toBuilder().symbol(this.data.get((int)0).symbol).build();
    }

    protected TickerMessage(TickerMessageBuilder<?, ?> b) {
        super((AbstractPublicationMessage.AbstractPublicationMessageBuilder<?, ?>)b);
        this.setChannel("ticker");
        this.data = b.data;
    }

    public static TickerMessageBuilder<?, ?> builder() {
        return new TickerMessageBuilderImpl();
    }

    public List<Ticker> getData() {
        return this.data;
    }

    public void setData(List<Ticker> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "TickerMessage(data=" + String.valueOf(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TickerMessage)) {
            return false;
        }
        TickerMessage other = (TickerMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Ticker> this$data = this.getData();
        List<Ticker> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TickerMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Ticker> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public TickerMessage(List<Ticker> data) {
        this.setChannel("ticker");
        this.data = data;
    }

    public TickerMessage() {
        this.setChannel("ticker");
    }

    public static class Ticker {
        @NonNull
        private BigDecimal ask;
        @JsonProperty(value="ask_qty", required=true)
        private BigDecimal askQuantity;
        @NonNull
        private BigDecimal bid;
        @JsonProperty(value="bid_qty", required=true)
        private BigDecimal bidQuantity;
        @NonNull
        private BigDecimal change;
        @JsonProperty(value="change_pct", required=true)
        private BigDecimal changeInPercentage;
        @NonNull
        private BigDecimal high;
        @NonNull
        private BigDecimal last;
        @NonNull
        private BigDecimal low;
        @NonNull
        private String symbol;
        @NonNull
        private BigDecimal volume;
        @NonNull
        private BigDecimal vwap;

        @NonNull
        public BigDecimal getAsk() {
            return this.ask;
        }

        public BigDecimal getAskQuantity() {
            return this.askQuantity;
        }

        @NonNull
        public BigDecimal getBid() {
            return this.bid;
        }

        public BigDecimal getBidQuantity() {
            return this.bidQuantity;
        }

        @NonNull
        public BigDecimal getChange() {
            return this.change;
        }

        public BigDecimal getChangeInPercentage() {
            return this.changeInPercentage;
        }

        @NonNull
        public BigDecimal getHigh() {
            return this.high;
        }

        @NonNull
        public BigDecimal getLast() {
            return this.last;
        }

        @NonNull
        public BigDecimal getLow() {
            return this.low;
        }

        @NonNull
        public String getSymbol() {
            return this.symbol;
        }

        @NonNull
        public BigDecimal getVolume() {
            return this.volume;
        }

        @NonNull
        public BigDecimal getVwap() {
            return this.vwap;
        }

        public void setAsk(@NonNull BigDecimal ask) {
            if (ask == null) {
                throw new NullPointerException("ask is marked non-null but is null");
            }
            this.ask = ask;
        }

        @JsonProperty(value="ask_qty", required=true)
        public void setAskQuantity(BigDecimal askQuantity) {
            this.askQuantity = askQuantity;
        }

        public void setBid(@NonNull BigDecimal bid) {
            if (bid == null) {
                throw new NullPointerException("bid is marked non-null but is null");
            }
            this.bid = bid;
        }

        @JsonProperty(value="bid_qty", required=true)
        public void setBidQuantity(BigDecimal bidQuantity) {
            this.bidQuantity = bidQuantity;
        }

        public void setChange(@NonNull BigDecimal change) {
            if (change == null) {
                throw new NullPointerException("change is marked non-null but is null");
            }
            this.change = change;
        }

        @JsonProperty(value="change_pct", required=true)
        public void setChangeInPercentage(BigDecimal changeInPercentage) {
            this.changeInPercentage = changeInPercentage;
        }

        public void setHigh(@NonNull BigDecimal high) {
            if (high == null) {
                throw new NullPointerException("high is marked non-null but is null");
            }
            this.high = high;
        }

        public void setLast(@NonNull BigDecimal last) {
            if (last == null) {
                throw new NullPointerException("last is marked non-null but is null");
            }
            this.last = last;
        }

        public void setLow(@NonNull BigDecimal low) {
            if (low == null) {
                throw new NullPointerException("low is marked non-null but is null");
            }
            this.low = low;
        }

        public void setSymbol(@NonNull String symbol) {
            if (symbol == null) {
                throw new NullPointerException("symbol is marked non-null but is null");
            }
            this.symbol = symbol;
        }

        public void setVolume(@NonNull BigDecimal volume) {
            if (volume == null) {
                throw new NullPointerException("volume is marked non-null but is null");
            }
            this.volume = volume;
        }

        public void setVwap(@NonNull BigDecimal vwap) {
            if (vwap == null) {
                throw new NullPointerException("vwap is marked non-null but is null");
            }
            this.vwap = vwap;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ticker)) {
                return false;
            }
            Ticker other = (Ticker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$ask = this.getAsk();
            BigDecimal other$ask = other.getAsk();
            if (this$ask == null ? other$ask != null : !((Object)this$ask).equals(other$ask)) {
                return false;
            }
            BigDecimal this$askQuantity = this.getAskQuantity();
            BigDecimal other$askQuantity = other.getAskQuantity();
            if (this$askQuantity == null ? other$askQuantity != null : !((Object)this$askQuantity).equals(other$askQuantity)) {
                return false;
            }
            BigDecimal this$bid = this.getBid();
            BigDecimal other$bid = other.getBid();
            if (this$bid == null ? other$bid != null : !((Object)this$bid).equals(other$bid)) {
                return false;
            }
            BigDecimal this$bidQuantity = this.getBidQuantity();
            BigDecimal other$bidQuantity = other.getBidQuantity();
            if (this$bidQuantity == null ? other$bidQuantity != null : !((Object)this$bidQuantity).equals(other$bidQuantity)) {
                return false;
            }
            BigDecimal this$change = this.getChange();
            BigDecimal other$change = other.getChange();
            if (this$change == null ? other$change != null : !((Object)this$change).equals(other$change)) {
                return false;
            }
            BigDecimal this$changeInPercentage = this.getChangeInPercentage();
            BigDecimal other$changeInPercentage = other.getChangeInPercentage();
            if (this$changeInPercentage == null ? other$changeInPercentage != null : !((Object)this$changeInPercentage).equals(other$changeInPercentage)) {
                return false;
            }
            BigDecimal this$high = this.getHigh();
            BigDecimal other$high = other.getHigh();
            if (this$high == null ? other$high != null : !((Object)this$high).equals(other$high)) {
                return false;
            }
            BigDecimal this$last = this.getLast();
            BigDecimal other$last = other.getLast();
            if (this$last == null ? other$last != null : !((Object)this$last).equals(other$last)) {
                return false;
            }
            BigDecimal this$low = this.getLow();
            BigDecimal other$low = other.getLow();
            if (this$low == null ? other$low != null : !((Object)this$low).equals(other$low)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                return false;
            }
            BigDecimal this$volume = this.getVolume();
            BigDecimal other$volume = other.getVolume();
            if (this$volume == null ? other$volume != null : !((Object)this$volume).equals(other$volume)) {
                return false;
            }
            BigDecimal this$vwap = this.getVwap();
            BigDecimal other$vwap = other.getVwap();
            return !(this$vwap == null ? other$vwap != null : !((Object)this$vwap).equals(other$vwap));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Ticker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $ask = this.getAsk();
            result = result * 59 + ($ask == null ? 43 : ((Object)$ask).hashCode());
            BigDecimal $askQuantity = this.getAskQuantity();
            result = result * 59 + ($askQuantity == null ? 43 : ((Object)$askQuantity).hashCode());
            BigDecimal $bid = this.getBid();
            result = result * 59 + ($bid == null ? 43 : ((Object)$bid).hashCode());
            BigDecimal $bidQuantity = this.getBidQuantity();
            result = result * 59 + ($bidQuantity == null ? 43 : ((Object)$bidQuantity).hashCode());
            BigDecimal $change = this.getChange();
            result = result * 59 + ($change == null ? 43 : ((Object)$change).hashCode());
            BigDecimal $changeInPercentage = this.getChangeInPercentage();
            result = result * 59 + ($changeInPercentage == null ? 43 : ((Object)$changeInPercentage).hashCode());
            BigDecimal $high = this.getHigh();
            result = result * 59 + ($high == null ? 43 : ((Object)$high).hashCode());
            BigDecimal $last = this.getLast();
            result = result * 59 + ($last == null ? 43 : ((Object)$last).hashCode());
            BigDecimal $low = this.getLow();
            result = result * 59 + ($low == null ? 43 : ((Object)$low).hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            BigDecimal $volume = this.getVolume();
            result = result * 59 + ($volume == null ? 43 : ((Object)$volume).hashCode());
            BigDecimal $vwap = this.getVwap();
            result = result * 59 + ($vwap == null ? 43 : ((Object)$vwap).hashCode());
            return result;
        }

        public String toString() {
            return "TickerMessage.Ticker(ask=" + String.valueOf(this.getAsk()) + ", askQuantity=" + String.valueOf(this.getAskQuantity()) + ", bid=" + String.valueOf(this.getBid()) + ", bidQuantity=" + String.valueOf(this.getBidQuantity()) + ", change=" + String.valueOf(this.getChange()) + ", changeInPercentage=" + String.valueOf(this.getChangeInPercentage()) + ", high=" + String.valueOf(this.getHigh()) + ", last=" + String.valueOf(this.getLast()) + ", low=" + String.valueOf(this.getLow()) + ", symbol=" + this.getSymbol() + ", volume=" + String.valueOf(this.getVolume()) + ", vwap=" + String.valueOf(this.getVwap()) + ")";
        }
    }

    public static abstract class TickerMessageBuilder<C extends TickerMessage, B extends TickerMessageBuilder<C, B>>
    extends AbstractPublicationMessage.AbstractPublicationMessageBuilder<C, B> {
        private List<Ticker> data;

        public B data(List<Ticker> data) {
            this.data = data;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TickerMessage.TickerMessageBuilder(super=" + super.toString() + ", data=" + String.valueOf(this.data) + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class TickerMessageBuilderImpl
    extends TickerMessageBuilder<TickerMessage, TickerMessageBuilderImpl> {
        private TickerMessageBuilderImpl() {
        }

        @Override
        protected TickerMessageBuilderImpl self() {
            return this;
        }

        @Override
        public TickerMessage build() {
            return new TickerMessage(this);
        }
    }
}

