/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.websocket.model.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.kraken.api.javawrapper.websocket.dto.request.RequestIdentifier;
import com.kraken.api.javawrapper.websocket.model.message.AbstractPublicationMessage;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.NonNull;

@JsonDeserialize(builder=TradeMessageBuilderImpl.class)
public class TradeMessage
extends AbstractPublicationMessage {
    private List<Trade> data;

    @Override
    public RequestIdentifier toRequestIdentifier() {
        return super.toRequestIdentifier().toBuilder().symbol(this.data.get((int)0).symbol).build();
    }

    protected TradeMessage(TradeMessageBuilder<?, ?> b) {
        super((AbstractPublicationMessage.AbstractPublicationMessageBuilder<?, ?>)b);
        this.setChannel("trade");
        this.data = b.data;
    }

    public static TradeMessageBuilder<?, ?> builder() {
        return new TradeMessageBuilderImpl();
    }

    public List<Trade> getData() {
        return this.data;
    }

    public void setData(List<Trade> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "TradeMessage(data=" + String.valueOf(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TradeMessage)) {
            return false;
        }
        TradeMessage other = (TradeMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Trade> this$data = this.getData();
        List<Trade> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TradeMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Trade> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public TradeMessage(List<Trade> data) {
        this.setChannel("trade");
        this.data = data;
    }

    public TradeMessage() {
        this.setChannel("trade");
    }

    public static class Trade {
        @JsonProperty(value="ord_type", required=true)
        private String orderType;
        @NonNull
        private BigDecimal price;
        @JsonProperty(value="qty", required=true)
        private BigDecimal quantity;
        @NonNull
        private String side;
        @NonNull
        private String symbol;
        @NonNull
        private ZonedDateTime timestamp;
        @JsonProperty(value="trade_id", required=true)
        private Integer tradeId;

        public String getOrderType() {
            return this.orderType;
        }

        @NonNull
        public BigDecimal getPrice() {
            return this.price;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        @NonNull
        public String getSide() {
            return this.side;
        }

        @NonNull
        public String getSymbol() {
            return this.symbol;
        }

        @NonNull
        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }

        public Integer getTradeId() {
            return this.tradeId;
        }

        @JsonProperty(value="ord_type", required=true)
        public void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        public void setPrice(@NonNull BigDecimal price) {
            if (price == null) {
                throw new NullPointerException("price is marked non-null but is null");
            }
            this.price = price;
        }

        @JsonProperty(value="qty", required=true)
        public void setQuantity(BigDecimal quantity) {
            this.quantity = quantity;
        }

        public void setSide(@NonNull String side) {
            if (side == null) {
                throw new NullPointerException("side is marked non-null but is null");
            }
            this.side = side;
        }

        public void setSymbol(@NonNull String symbol) {
            if (symbol == null) {
                throw new NullPointerException("symbol is marked non-null but is null");
            }
            this.symbol = symbol;
        }

        public void setTimestamp(@NonNull ZonedDateTime timestamp) {
            if (timestamp == null) {
                throw new NullPointerException("timestamp is marked non-null but is null");
            }
            this.timestamp = timestamp;
        }

        @JsonProperty(value="trade_id", required=true)
        public void setTradeId(Integer tradeId) {
            this.tradeId = tradeId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Trade)) {
                return false;
            }
            Trade other = (Trade)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$tradeId = this.getTradeId();
            Integer other$tradeId = other.getTradeId();
            if (this$tradeId == null ? other$tradeId != null : !((Object)this$tradeId).equals(other$tradeId)) {
                return false;
            }
            String this$orderType = this.getOrderType();
            String other$orderType = other.getOrderType();
            if (this$orderType == null ? other$orderType != null : !this$orderType.equals(other$orderType)) {
                return false;
            }
            BigDecimal this$price = this.getPrice();
            BigDecimal other$price = other.getPrice();
            if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
                return false;
            }
            BigDecimal this$quantity = this.getQuantity();
            BigDecimal other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            String this$side = this.getSide();
            String other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$symbol = this.getSymbol();
            String other$symbol = other.getSymbol();
            if (this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol)) {
                return false;
            }
            ZonedDateTime this$timestamp = this.getTimestamp();
            ZonedDateTime other$timestamp = other.getTimestamp();
            return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Trade;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $tradeId = this.getTradeId();
            result = result * 59 + ($tradeId == null ? 43 : ((Object)$tradeId).hashCode());
            String $orderType = this.getOrderType();
            result = result * 59 + ($orderType == null ? 43 : $orderType.hashCode());
            BigDecimal $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
            BigDecimal $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            String $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $symbol = this.getSymbol();
            result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
            ZonedDateTime $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            return result;
        }

        public String toString() {
            return "TradeMessage.Trade(orderType=" + this.getOrderType() + ", price=" + String.valueOf(this.getPrice()) + ", quantity=" + String.valueOf(this.getQuantity()) + ", side=" + this.getSide() + ", symbol=" + this.getSymbol() + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", tradeId=" + this.getTradeId() + ")";
        }
    }

    public static abstract class TradeMessageBuilder<C extends TradeMessage, B extends TradeMessageBuilder<C, B>>
    extends AbstractPublicationMessage.AbstractPublicationMessageBuilder<C, B> {
        private List<Trade> data;

        public B data(List<Trade> data) {
            this.data = data;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TradeMessage.TradeMessageBuilder(super=" + super.toString() + ", data=" + String.valueOf(this.data) + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class TradeMessageBuilderImpl
    extends TradeMessageBuilder<TradeMessage, TradeMessageBuilderImpl> {
        private TradeMessageBuilderImpl() {
        }

        @Override
        protected TradeMessageBuilderImpl self() {
            return this;
        }

        @Override
        public TradeMessage build() {
            return new TradeMessage(this);
        }
    }
}

