/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.websocket.model.method;

import com.kraken.api.javawrapper.websocket.dto.request.RequestIdentifier;
import com.kraken.api.javawrapper.websocket.model.method.AbstractRequest;
import com.kraken.api.javawrapper.websocket.model.method.AbstractResponse;
import com.kraken.api.javawrapper.websocket.model.method.detail.AbstractParameter;
import com.kraken.api.javawrapper.websocket.model.method.detail.AbstractResult;
import java.time.ZonedDateTime;
import java.util.List;

public abstract class Interaction {

    public static abstract class AbstractInteractionResponse
    extends AbstractResponse {
        private AbstractResult result;
        private Boolean success;
        private String error;

        @Override
        public RequestIdentifier toRequestIdentifier() {
            return super.toRequestIdentifier().toBuilder().channel(this.result.getChannel()).symbol(this.result.getSymbol()).build();
        }

        protected AbstractInteractionResponse(AbstractInteractionResponseBuilder<?, ?> b) {
            super((AbstractResponse.AbstractResponseBuilder<?, ?>)b);
            this.result = b.result;
            this.success = b.success;
            this.error = b.error;
        }

        public AbstractResult getResult() {
            return this.result;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public String getError() {
            return this.error;
        }

        public void setResult(AbstractResult result) {
            this.result = result;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public void setError(String error) {
            this.error = error;
        }

        @Override
        public String toString() {
            return "Interaction.AbstractInteractionResponse(result=" + String.valueOf(this.getResult()) + ", success=" + this.getSuccess() + ", error=" + this.getError() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbstractInteractionResponse)) {
                return false;
            }
            AbstractInteractionResponse other = (AbstractInteractionResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$success = this.getSuccess();
            Boolean other$success = other.getSuccess();
            if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
                return false;
            }
            AbstractResult this$result = this.getResult();
            AbstractResult other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof AbstractInteractionResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
            AbstractResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        public AbstractInteractionResponse(AbstractResult result, Boolean success, String error) {
            this.result = result;
            this.success = success;
            this.error = error;
        }

        public AbstractInteractionResponse() {
        }

        public static abstract class AbstractInteractionResponseBuilder<C extends AbstractInteractionResponse, B extends AbstractInteractionResponseBuilder<C, B>>
        extends AbstractResponse.AbstractResponseBuilder<C, B> {
            private AbstractResult result;
            private Boolean success;
            private String error;

            public B result(AbstractResult result) {
                this.result = result;
                return (B)this.self();
            }

            public B success(Boolean success) {
                this.success = success;
                return (B)this.self();
            }

            public B error(String error) {
                this.error = error;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "Interaction.AbstractInteractionResponse.AbstractInteractionResponseBuilder(super=" + super.toString() + ", result=" + String.valueOf(this.result) + ", success=" + this.success + ", error=" + this.error + ")";
            }
        }
    }

    public static abstract class AbstractInteractionRequest
    extends AbstractRequest {
        private AbstractParameter params;

        public List<RequestIdentifier> toRequestIdentifiers(ZonedDateTime timestamp) {
            RequestIdentifier.Builder builder = super.toRequestIdentifier(timestamp).toBuilder();
            return this.params.getSymbols().stream().map(e -> builder.channel(this.params.getChannel()).symbol((String)e).build()).toList();
        }

        protected AbstractInteractionRequest(AbstractInteractionRequestBuilder<?, ?> b) {
            super((AbstractRequest.AbstractRequestBuilder<?, ?>)b);
            this.params = b.params;
        }

        public AbstractParameter getParams() {
            return this.params;
        }

        public void setParams(AbstractParameter params) {
            this.params = params;
        }

        @Override
        public String toString() {
            return "Interaction.AbstractInteractionRequest(params=" + String.valueOf(this.getParams()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbstractInteractionRequest)) {
                return false;
            }
            AbstractInteractionRequest other = (AbstractInteractionRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractParameter this$params = this.getParams();
            AbstractParameter other$params = other.getParams();
            return !(this$params == null ? other$params != null : !this$params.equals(other$params));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof AbstractInteractionRequest;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            AbstractParameter $params = this.getParams();
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            return result;
        }

        public AbstractInteractionRequest(AbstractParameter params) {
            this.params = params;
        }

        public AbstractInteractionRequest() {
        }

        public static abstract class AbstractInteractionRequestBuilder<C extends AbstractInteractionRequest, B extends AbstractInteractionRequestBuilder<C, B>>
        extends AbstractRequest.AbstractRequestBuilder<C, B> {
            private AbstractParameter params;

            public B params(AbstractParameter params) {
                this.params = params;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "Interaction.AbstractInteractionRequest.AbstractInteractionRequestBuilder(super=" + super.toString() + ", params=" + String.valueOf(this.params) + ")";
            }
        }
    }
}

