/*
 * Decompiled with CFR 0.152.
 */
package com.kraken.api.javawrapper.websocket.utils;

import com.kraken.api.javawrapper.websocket.dto.request.RequestIdentifier;
import com.kraken.api.javawrapper.websocket.model.message.AbstractPublicationMessage;
import com.kraken.api.javawrapper.websocket.model.message.StatusMessage;
import com.kraken.api.javawrapper.websocket.model.method.AbstractResponse;
import com.kraken.api.javawrapper.websocket.model.method.Interaction;
import com.kraken.api.javawrapper.websocket.model.method.Unsubscription;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.ReplaySubject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class WebSocketTrafficGateway {
    public final PublishSubject<StatusMessage> statusMessages = PublishSubject.create();
    private final Map<RequestIdentifier, Object> requestsToResponsesMap = new LinkedHashMap<RequestIdentifier, Object>();
    private final Map<RequestIdentifier, Object> subscriptionsToPublicationsMap = new HashMap<RequestIdentifier, Object>();

    public void responseAnnounce(StatusMessage statusMessage) {
        this.statusMessages.onNext((Object)statusMessage);
    }

    public <T extends RequestIdentifier, U extends AbstractResponse> void registerRequest(T requestIdentifier, ReplaySubject<U> responseMessageReplaySubject) {
        this.requestsToResponsesMap.put(requestIdentifier, responseMessageReplaySubject);
    }

    public <U extends Interaction.AbstractInteractionResponse> Single<U> retrieveResponse(RequestIdentifier requestIdentifier) {
        return ((ReplaySubject)this.requestsToResponsesMap.get(requestIdentifier)).firstOrError();
    }

    public PublishSubject<AbstractPublicationMessage> subscribePublication(RequestIdentifier requestIdentifier) {
        PublishSubject publicationMessageReplaySubject = (PublishSubject)this.subscriptionsToPublicationsMap.getOrDefault(requestIdentifier, PublishSubject.create());
        this.subscriptionsToPublicationsMap.putIfAbsent(requestIdentifier, publicationMessageReplaySubject);
        return publicationMessageReplaySubject;
    }

    public <U extends AbstractResponse> void removeErrorRequest(U response) {
        Iterator<Map.Entry<RequestIdentifier, Object>> mapIterator = this.requestsToResponsesMap.entrySet().iterator();
        Map.Entry<RequestIdentifier, Object> nextMapEntry = mapIterator.next();
        RequestIdentifier requestEntry = nextMapEntry.getKey();
        assert (requestEntry.getRequestId().equals(response.getRequestId()));
        assert (response.getTimeIn().isAfter(requestEntry.getTimestamp()));
        ReplaySubject responseSubject = (ReplaySubject)nextMapEntry.getValue();
        responseSubject.onNext(response);
        responseSubject.onComplete();
        mapIterator.remove();
    }

    public <U extends AbstractResponse> void responseReply(U response) {
        RequestIdentifier requestIdentifier = response.toRequestIdentifier();
        ReplaySubject responseSubject = (ReplaySubject)this.requestsToResponsesMap.remove(requestIdentifier);
        responseSubject.onNext(response);
        responseSubject.onComplete();
    }

    public <P extends AbstractPublicationMessage> void publishMessage(P publicationMessage) {
        RequestIdentifier subscribeRequestIdentifier = publicationMessage.toRequestIdentifier();
        ((PublishSubject)this.subscriptionsToPublicationsMap.get(subscribeRequestIdentifier)).onNext(publicationMessage);
    }

    public <P extends AbstractPublicationMessage> void unsubscribeRequest(Unsubscription.UnsubscribeResponse unsubscribeResponse) {
        RequestIdentifier requestIdentifier = unsubscribeResponse.toRequestIdentifier();
        requestIdentifier.setRequestId(null);
        PublishSubject abstractPublishMessageSubject = (PublishSubject)this.subscriptionsToPublicationsMap.remove(requestIdentifier);
        abstractPublishMessageSubject.onComplete();
    }

    public PublishSubject<StatusMessage> getStatusMessages() {
        return this.statusMessages;
    }

    public Map<RequestIdentifier, Object> getRequestsToResponsesMap() {
        return this.requestsToResponsesMap;
    }

    public Map<RequestIdentifier, Object> getSubscriptionsToPublicationsMap() {
        return this.subscriptionsToPublicationsMap;
    }
}

