/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.service.v2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.nicepay.api.v2.QrisRequestV2;
import io.github.nicepay.data.model.Qris;
import io.github.nicepay.data.response.v2.NICEPayResponseV2;
import io.github.nicepay.service.v2.V2CommonService;
import io.github.nicepay.utils.ApiUtils;
import io.github.nicepay.utils.NICEPay;
import io.github.nicepay.utils.SHA256Util;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class V2QrisService
extends V2CommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"[V2 - Qris]");

    public static <S> S callV2QrisRegistration(Qris data, NICEPay config) throws IOException {
        LOGGER.info("\u001b[32m {} \u001b[0m", (Object)"START CALL V2 QRIS REGISTRATION");
        Gson gson = new Gson();
        QrisRequestV2 request = ApiUtils.createServiceV2(QrisRequestV2.class, config);
        data.setMerchantToken(SHA256Util.encrypt(data.getMerchantToken()));
        Call<NICEPayResponseV2> callSync = request.registerQris(data);
        NICEPayResponseV2 nicePayResponse = null;
        try {
            Response response = callSync.execute();
            nicePayResponse = (NICEPayResponseV2)response.body();
            ResponseBody errorResponse = response.errorBody();
            String resClient = nicePayResponse == null ? errorResponse.string() : gson.toJson((Object)nicePayResponse);
            JsonObject jsonObject = JsonParser.parseString((String)resClient.toString()).getAsJsonObject();
            LOGGER.info("\u001b[35m {} \u001b[0m", (Object)("Response register QRIS transaction :" + new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)jsonObject)));
            LOGGER.info("\u001b[32m {} \u001b[0m", (Object)"END CALL V2 QRIS REGISTRATION");
        }
        catch (Exception ex) {
            LOGGER.error("\u001b[31m {} \u001b[0m", (Object)"QRIS transaction registration failed :");
            ex.printStackTrace();
        }
        return (S)nicePayResponse;
    }
}

