/*
 * Decompiled with CFR 0.152.
 */
package io.github.nicepay.utils;

import io.github.nicepay.utils.NICEPayConstants;

public class NICEPay {
    private String partnerId;
    private String clientSecret;
    private boolean isProduction;
    private boolean isCloudServer;
    private String externalID;
    private String timestamp;
    private String privateKey;

    public NICEPay(String partnerId, String clientSecret, boolean isProduction, boolean isCloudServer, String externalID, String timestamp, String privateKey) {
        this.partnerId = partnerId;
        this.clientSecret = clientSecret;
        this.isProduction = isProduction;
        this.isCloudServer = isCloudServer;
        this.externalID = externalID;
        this.timestamp = timestamp;
        this.privateKey = privateKey;
    }

    public String getNICEPayBaseUrl() {
        if (this.isProduction) {
            return NICEPayConstants.getProductionBaseUrl(this.isCloudServer);
        }
        return NICEPayConstants.getSandboxBaseUrl(this.isCloudServer);
    }

    public String toString() {
        return "NICEPay{partnerId='" + this.partnerId + "', clientSecret='" + this.clientSecret + "', isProduction=" + this.isProduction + "}";
    }

    public static NICEPayBuilder builder() {
        return new NICEPayBuilder();
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean isProduction() {
        return this.isProduction;
    }

    public boolean isCloudServer() {
        return this.isCloudServer;
    }

    public String getExternalID() {
        return this.externalID;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setProduction(boolean isProduction) {
        this.isProduction = isProduction;
    }

    public void setCloudServer(boolean isCloudServer) {
        this.isCloudServer = isCloudServer;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public static class NICEPayBuilder {
        private String partnerId;
        private String clientSecret;
        private boolean isProduction;
        private boolean isCloudServer;
        private String externalID;
        private String timestamp;
        private String privateKey;

        NICEPayBuilder() {
        }

        public NICEPayBuilder partnerId(String partnerId) {
            this.partnerId = partnerId;
            return this;
        }

        public NICEPayBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public NICEPayBuilder isProduction(boolean isProduction) {
            this.isProduction = isProduction;
            return this;
        }

        public NICEPayBuilder isCloudServer(boolean isCloudServer) {
            this.isCloudServer = isCloudServer;
            return this;
        }

        public NICEPayBuilder externalID(String externalID) {
            this.externalID = externalID;
            return this;
        }

        public NICEPayBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public NICEPayBuilder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public NICEPay build() {
            return new NICEPay(this.partnerId, this.clientSecret, this.isProduction, this.isCloudServer, this.externalID, this.timestamp, this.privateKey);
        }

        public String toString() {
            return "NICEPay.NICEPayBuilder(partnerId=" + this.partnerId + ", clientSecret=" + this.clientSecret + ", isProduction=" + this.isProduction + ", isCloudServer=" + this.isCloudServer + ", externalID=" + this.externalID + ", timestamp=" + this.timestamp + ", privateKey=" + this.privateKey + ")";
        }
    }
}

