/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchUtil {
    public static <T> BatchIterator<T> batch(int batchSize, List<T> item) {
        int size = item.size();
        HashMap map = new HashMap();
        BatchIterator batchIterator = new BatchIterator(map);
        if (size > batchSize) {
            ArrayList<T> list;
            int count = size / batchSize;
            int remaining = size % batchSize;
            for (int index = 0; index < count; ++index) {
                list = new ArrayList<T>();
                for (int i = 0; i < batchSize; ++i) {
                    list.add(item.get(index * batchSize + i));
                }
                map.put(index, list);
            }
            int next = count;
            list = new ArrayList();
            int index = count * batchSize;
            for (int i = 0; i < remaining; ++i) {
                list.add(item.get(index + i));
            }
            map.put(next, list);
        } else {
            map.put(0, item);
        }
        return batchIterator;
    }

    public static void main(String[] args) {
        List next;
        ArrayList<Long> list = new ArrayList<Long>();
        for (int i = 0; i < 1023; ++i) {
            list.add(Long.valueOf(i));
        }
        BatchIterator batch = BatchUtil.batch(30, list);
        while (batch.hasNext()) {
            next = batch.next();
            next.stream().forEach(System.out::println);
        }
        batch.rest();
        while (batch.hasNext()) {
            next = batch.next();
            next.stream().forEach(System.out::println);
        }
    }

    public static class BatchIterator<T> {
        private Map<Integer, List<T>> map;
        private int index;

        public BatchIterator(Map<Integer, List<T>> listMap) {
            this.map = listMap;
            this.index = 0;
        }

        public boolean hasNext() {
            return this.index < this.map.size();
        }

        public List<T> next() {
            List<T> t = this.map.get(this.index);
            ++this.index;
            System.out.println("\u5206\u6bb5: " + this.index);
            return t;
        }

        public void rest() {
            this.index = 0;
        }

        public Map<Integer, List<T>> getGroupData() {
            return this.map;
        }
    }
}

