package io.github.nier6088.enums;

/**
 * 外部第三方以10开头
 * <p>
 * 当前服务以40开头 后二位代表模块
 * 通用默认：00 (参数错误，服务不存在，已存在等可以通用的 或默认)
 * 账号：01 （租户状态， 账号权限， 账号是否锁定等）
 * 用户模块USER: 02
 * 剧本模块SCRIPT: 03
 * 店铺模块SHOP: 04
 * 订单模块ORDER: 05
 * 微信小程序WXMA:06
 * 微信商户wxmerchant:07
 * 充值模块:08
 * 优惠券 09
 * 例子：
 * 通用
 * SERVICE_STATE_SERVER_NOT_FOUND(400000,"服务不存在"),
 * 订单模块
 * SERVICE_STATE_ORDER_SESSION_NOT_EXISTS(400500,"场次不存在");
 */
public enum ServiceStateCodeEnum {
    // 内部问题
    SERVICE_STATE_ERROR(500, "服务开小差啦，稍等片刻;"),

    // 微信支付
    WX_PAY_PARSE_PAY_SUCCESS_TIME_ERROR(100100, "微信回调解析支付时间错误"),

    // 通用
    SERVICE_STATE_SERVER_NOT_FOUND(400000, "服务不存在"),
    SERVICE_STATE_IMPORT_ERROR(4000010, "暂无数据导入"),

    SERVICE_STATE_HEADER_VALIDATE_ERROR(400001, "header参数不能为空"),
    SERVICE_STATE_PARAM_VALIDATE_ERROR(400002, "参数校验错误;"),
    SERVICE_STATE_CLIENT_SIGN_ERROR(400003, "无效来源"),
    SERVICE_STATE_PARAM_TENANT_ID_VALIDATE_ERROR(400003, "参数租户ID校验错误;"),
    SERVICE_STATE_PARAM_WX_APP_ID_VALIDATE_ERROR(400004, "参数微信应用ID校验错误;"),
    SERVICE_STATE_PARAM_SHOP_ID_VALIDATE_ERROR(400005, "参数商店ID校验错误;"),

    SERVICE_STATE_DATA_DUPLICATE_KEY(400003, "该信息已存在;"),
    SERVICE_STATE_REQUEST_LIMIT_ERROR(400004, "请求次数频繁，请稍后再试。"),

    SERVICE_STATE_SMS_CODE(400005, "验证码错误"),
    SERVICE_STATE_SMS_SEND_VALIDATE(400006, "短信发送不合法"),
    SERVICE_STATE_SMS_SEND_FAIL(400007, "短信发送失败，请稍后再试"),


    // 账号状态 权限 模块
    SERVICE_STATE_ACCOUNT_NOT_LOGIN_ERROR(400100, "请登录"),
    SERVICE_STATE_ACCOUNT_NO_PERMISSION_ERROR(400102, "没有权限执行该操作"),
    SERVICE_STATE_SHOP_ROLE_MEMBER_NOT_INIT_ERROR(400103, "店铺尚未初始化普通员工角色"),

    SERVICE_STATE_ACCOUNT_NOT_EXISTS(400102, "帐号不存在"),
    SERVICE_STATE_ACCOUNT_EXISTS(400103, "帐号已存在"),
    SERVICE_STATE_ACCOUNT_PASSWORD_ERROR(400104, "账号密码不正确"),
    SERVICE_STATE_MOBILE_EXISTS(400105, "手机号码已存在"),
    SERVICE_STATE_EMAIL_EXISTS(400106, "邮箱已存在"),

    //用户
    SERVICE_STATE_USER_NOT_EXISTS(400200, "用户不存在"),
    SERVICE_STATE_NON_OFFLINE_USERS_EXISTS(400201, "非线下用户"),

    SERVICE_STATE_SHOP_USER_BALANCE_ERROR(400202, "余额不足"),
    SERVICE_STATE_SCRIPT_NOT_EXISTS(400300, "剧本不存在"),


    // 店铺
    SERVICE_STATE_SHOP_NOT_EXISTS(400400, "店铺不存在"),
    SERVICE_STATE_SHOP_MEMBER_EXISTS(400401, "用户已是店铺店员"),
    SERVICE_STATE_SHOP_EXPORT_EMPTY(400402, "当前暂无数据不支持导出"),
    SERVICE_STATE_SHOP_MEMBER_NOT_EXISTS(400403, "店铺成员不存在"),
    SERVICE_STATE_SHOP_MEMBER_MUST_SET(400404, "需要设置邀请人"),


    // 订单模块
    SERVICE_STATE_ORDER_SESSION_NOT_EXISTS(400500, "场次不存在"),
    SERVICE_STATE_ORDER_PAY_RECORD_NOT_EXISTS(400501, "订单记录不存在"),
    SERVICE_STATE_ORDER_SESSION_FINISH(400502, "场次已结束"),
    SERVICE_STATE_ORDER_SESSION_PAYEE_COUNT_LIMIT_ERROR(400503, "场次支付人数超过上限"),
    SERVICE_STATE_ORDER_SESSION_PAYEE_COUNT_LIMIT_DOWN_ERROR(400504, "场次支付人数不正确"),
    SERVICE_STATE_ORDER_PAY_TRADE_TYPE_ERROR(400505, "该订单不支持删除"),

    SERVICE_STATE_ORDER_PAY_USE_COUPON_ERROR(400506, "该场次不支持使用优惠券折扣"),
    SERVICE_STATE_ORDER_PAY_USE_BALANCE_ERROR(400507, "该场次不支持使用余额抵扣"),
    SERVICE_STATE_ORDER_PAY_USE_BALANCE2_ERROR(400508, "优惠券已使用"),
    SERVICE_STATE_ORDER_PAY_MONEY_INCONSISTENT_ERROR(400501, "订单金额不一致"),


    //小程序注册
    SERVICE_STATE_USER_TOKEN_NULL_ERROR(400600, "token不合法"),
    SERVICE_STATE_MINI_UNDER_APPLICATION_ERROR(400610, "当前企业小程序已在申请中"),
    SERVICE_STATE_BUSINESS_LICENSE_CANNOT_RECOGNIZED(400611, "营业执照无法识别"),
    SERVICE_STATE_BUSINESS_LICENSE_LEGAL_PERSON_DISCREPANCY(400612, "法人姓名和营业执照执法人照姓名不符"),
    SERVICE_STATE_WX_MINI_ERROR(400613, "小程序不存在，或已解绑"),
    SERVICE_STATE_WX_MINI_CLAIM(400614, "小程序已被认领"),
    SERVICE_STATE_WX_MINI_PHONE(400615, "认领手机号和申请时手机号不符"),
    SERVICE_STATE_WX_MINI_CODE_COMMIT(400616, "上传代码并生成体验版失败"),
    SERVICE_STATE_WX_MINI_MOST_APPLICATION_ERROR(400617, "最多申请5个独立的小程序"),
    SERVICE_STATE_WX_MINI_GET_HISTORY_VERSION_ERROR(400618, "获取小程序可回退的版本列表"),
    SERVICE_STATE_WX_MINI_GET_VERSION_INFO_ERROR(400619, "查询小程序版本信息"),
    SERVICE_STATE_WX_MINI_CHECK_VERIFY_NICK_NAME_ERROR(400620, "查询小程序版本信息"),
    SERVICE_STATE_WX_MINI_MODIFY_HEAD_IMAGE_ERROR(400621, "设置小程序头像"),
    SERVICE_STATE_WX_MINI_SET_NICK_NAME_ERROR(400622, "设置小程序昵称"),

    SERVICE_STATE_WX_MINI_NO_TEMPLATE_ERROR(400650, "暂无小程序模板"),

    // 商户
    SERVICE_STATE_MERCHANT_NOT_APPLY(400700, "未开通商户"),
    SERVICE_STATE_MERCHANT_STATUS_ERROR(400701, "商户申请尚未审核通过"),

    SERVICE_STATE_MERCHANT_ID_TRIGGER_ERROR(400702, "切换商户id出现错误"),

    SERVICE_STATE_MERCHANT_FLOW_ERROR(400703, "商户申请尚未审核通过"),
    //充值
    SERVICE_STATE_RECHARGE_TEMPLATE_ERROR(400801, "充值模板不存在"),


    //优惠券
    SERVICE_STATE_COUPON_NOT_START_ERROR(400900, "优惠券未开始"),
    SERVICE_STATE_COUPON_EXPIRES(400901, "优惠券已过期"),
    SERVICE_STATE_COUPON_FULL_AMOUNT_ERROR(400902, "订单金额不支持使用满减券"),
    SERVICE_STATE_COUPON_DISCOUNT_TYPE_ERROR(400903, "当前优惠券不可用"),
    SERVICE_STATE_COUPON_DATE_TYPE_ERROR(400904, "当前优惠券不可用"),
    SERVICE_STATE_COUPON_SCRIPT_ERROR(400905, "优惠券不支持当前剧本"),
    SERVICE_STATE_COUPON_NOT_EXIST_ERROR(400906, "优惠券不存在"),
    SERVICE_STATE_COUPON_NUM_ERROR(400907, "当前最多创建15个优惠券"),

    //绑定谜圈商家
    SHOP_BIND_MIQUAN_NOT_EXIST_ERROR(401000, "不存在绑定谜圈商家信息"),

    SERVICE_STATE_CATEGORY_EXIST(4011000, "分类已存在"),
    SERVICE_STATE_ACTIVE_NOT_EXIST(4012000, "活动不存在"),
    SERVICE_STATE_ACTIVE_DATA_ERROR(4012001, "活动日期不对"),
    ACTIVE_END_DATE_ERROR(4012002, "活动已结束"),
    ACTIVE_SIGNUP_DATE_ERROR(4012003, "报名已结束"),
    ACTIVE_CATEGORY_REMOVE_ACTIVE_EXIST_ERROR(4012001, "删除活动分类失败，该分类下有活动存在");


    ServiceStateCodeEnum(int code, String describe) {
        this.code = code;
        this.describe = describe;
    }


    private final int code;
    private final String describe;

    public int getCode() {
        return code;
    }

    public String getDescribe() {
        return describe;
    }
}
