/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.aop;

import cn.hutool.core.util.IdUtil;
import cn.hutool.extra.servlet.ServletUtil;
import io.github.nier6088.constants.BusConstant;
import io.github.nier6088.exception.ParamValidateException;
import io.github.nier6088.mapper.ServiceReqLogInfoMapper;
import io.github.nier6088.model.entity.ServiceReqLogInfoEntity;
import io.github.nier6088.util.ObjectMapperUtil;
import io.github.nier6088.util.ServletUtils;
import io.github.nier6088.util.SpringContextUtil;
import io.github.nier6088.wrapper.ResultCode;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Order(value=-1)
@Component
public class WebLogAspect
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger log = LoggerFactory.getLogger(WebLogAspect.class);
    private static final ThreadLocal<Long> TIME_THREADLOCAL = new NamedThreadLocal("Cost Time");
    @Autowired
    private ServiceReqLogInfoMapper serviceReqLogInfoMapper;

    @Pointcut(value="execution(public * com.boolib.*.api..*.*(..))")
    public void logPointCut() {
    }

    @Pointcut(value="execution(public * com.boolib.*.api..*.*(..))")
    public void paramValidate() {
    }

    @Before(value="paramValidate()")
    @Order(value=1)
    public void doBefore1(JoinPoint joinPoint) {
        for (Object arg : joinPoint.getArgs()) {
            BindingResult result;
            if (!(arg instanceof BindingResult) || !(result = (BindingResult)arg).hasErrors()) continue;
            FieldError error = result.getFieldError();
            throw new ParamValidateException(ResultCode.FAIL.getCode(), error.getField() + error.getDefaultMessage());
        }
    }

    @Before(value="logPointCut()")
    @Order(value=2)
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void doBefore2(JoinPoint joinPoint) {
        TIME_THREADLOCAL.set(System.currentTimeMillis());
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestUrl = request.getRequestURL().toString();
        String remoteIp = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
        boolean filterResult = BusConstant.NO_FILTER_REQ_URLS.stream().noneMatch(info -> requestUrl.contains((CharSequence)info));
        if (filterResult) {
            String requestURI = request.getRequestURL().toString();
            ServiceReqLogInfoEntity serviceReqLogInfo = new ServiceReqLogInfoEntity();
            Long id = IdUtil.getSnowflakeNextId();
            serviceReqLogInfo.setId(id);
            serviceReqLogInfo.setReqUrl(requestURI);
            serviceReqLogInfo.setReqId(MDC.get((String)"reqId"));
            String method = ServletUtils.getRequest().getMethod();
            serviceReqLogInfo.setReqMethod(method);
            serviceReqLogInfo.setReqParams(ObjectMapperUtil.toStr(request.getParameterMap()));
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String key = (String)headerNames.nextElement();
                headers.put(key, request.getHeader(key));
            }
            String header = ObjectMapperUtil.toStr(headers);
            serviceReqLogInfo.setReqHeader(header);
            Object[] args = joinPoint.getArgs();
            String body = ObjectMapperUtil.toStr(args);
            serviceReqLogInfo.setReqBody(body);
            serviceReqLogInfo.setReqIp(remoteIp);
            this.serviceReqLogInfoMapper.insert(serviceReqLogInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterReturning(value="logPointCut()", returning="result")
    public void doAfterReturning(JoinPoint joinPoint, Object result) {
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            String requestUrl = request.getRequestURL().toString();
            String remoteIp = ServletUtil.getClientIP((HttpServletRequest)request, (String[])new String[0]);
            boolean filterResult = BusConstant.NO_FILTER_REQ_URLS.stream().noneMatch(info -> requestUrl.contains((CharSequence)info));
            if (filterResult) {
                if (SpringContextUtil.isDeveloperMode()) {
                    System.out.println("[RequestURL] = " + requestUrl + " , [RequestIp] = " + remoteIp);
                    log.info("[RequestParam] = {}", (Object)ObjectMapperUtil.toStr(joinPoint.getArgs()));
                    log.info("[ResponseResult] = {}", (Object)ObjectMapperUtil.toStr(result));
                    log.info("[costTime] = {}ms ", (Object)(System.currentTimeMillis() - TIME_THREADLOCAL.get()));
                } else {
                    log.info("[RequestParam] = {}, {}, {}, [ResponseResult] = {}", new Object[]{remoteIp, requestUrl, ObjectMapperUtil.toStr(joinPoint.getArgs()), ObjectMapperUtil.toStr(result)});
                }
            }
        }
        finally {
            TIME_THREADLOCAL.remove();
        }
    }

    @AfterThrowing(value="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Exception e) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String requestUrl = request.getRequestURL().toString();
        String remoteIp = request.getRemoteAddr();
        if (SpringContextUtil.isDeveloperMode()) {
            System.out.println("[RequestURL] = " + requestUrl + " , [RequestIp] = " + remoteIp);
            log.info("[RequestParam] = {}", (Object)ObjectMapperUtil.toStr(joinPoint.getArgs()));
        } else {
            log.info("[RequestParam] = {}, {}, {}", new Object[]{remoteIp, requestUrl, ObjectMapperUtil.toStr(joinPoint.getArgs())});
        }
        TIME_THREADLOCAL.remove();
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        Class mainApplicationClass = event.getSpringApplication().getMainApplicationClass();
        System.out.println("mainApplicationClass.getPackage().getName() = " + mainApplicationClass.getPackage().getName());
    }
}

