/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.async;

import io.github.nier6088.async.AsyncExceptionHandler;
import io.github.nier6088.pool.DefaultMdcDecorator;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class AsyncServicePoolConfig
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AsyncServicePoolConfig.class);
    private final AsyncExceptionHandler asyncExceptionHandler;
    @Value(value="${thread.pool.executor.corePoolSize:10}")
    private int corePoolSize;
    @Value(value="${thread.pool.executor.maxPoolSize:20}")
    private int maxPoolSize;
    @Value(value="${thread.pool.executor.queueCapacity:100}")
    private int queueCapacity;
    @Value(value="${thread.pool.executor.keepAliveSeconds:60}")
    private int keepAliveSeconds;

    @Qualifier
    @Bean
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor defaultPoolTaskExecutor = new ThreadPoolTaskExecutor();
        defaultPoolTaskExecutor.setThreadNamePrefix("asyncPool");
        defaultPoolTaskExecutor.setCorePoolSize(this.corePoolSize);
        defaultPoolTaskExecutor.setMaxPoolSize(this.maxPoolSize);
        defaultPoolTaskExecutor.setKeepAliveSeconds(this.keepAliveSeconds);
        defaultPoolTaskExecutor.setQueueCapacity(this.queueCapacity);
        defaultPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        defaultPoolTaskExecutor.initialize();
        defaultPoolTaskExecutor.setTaskDecorator((TaskDecorator)new DefaultMdcDecorator());
        return defaultPoolTaskExecutor;
    }

    @Qualifier
    @Bean(value={"activePool"})
    public ThreadPoolTaskExecutor activePool() {
        ThreadPoolTaskExecutor defaultPoolTaskExecutor = new ThreadPoolTaskExecutor();
        defaultPoolTaskExecutor.setThreadNamePrefix("activePool");
        defaultPoolTaskExecutor.setCorePoolSize(10);
        defaultPoolTaskExecutor.setMaxPoolSize(20);
        defaultPoolTaskExecutor.setKeepAliveSeconds(60);
        defaultPoolTaskExecutor.setQueueCapacity(100);
        defaultPoolTaskExecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        defaultPoolTaskExecutor.initialize();
        defaultPoolTaskExecutor.setTaskDecorator((TaskDecorator)new DefaultMdcDecorator());
        return defaultPoolTaskExecutor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return this.asyncExceptionHandler;
    }

    public AsyncServicePoolConfig(AsyncExceptionHandler asyncExceptionHandler) {
        this.asyncExceptionHandler = asyncExceptionHandler;
    }
}

