/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.config;

import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class GlobalCacheRedisCacheConfiguration {
    @Value(value="${spring.redis.database}")
    private int database;
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.timeout}")
    private long timeout;
    @Value(value="${spring.redis.lettuce.shutdown-timeout}")
    private long shutDownTimeout;
    @Value(value="${spring.redis.lettuce.pool.max-idle}")
    private int maxIdle;
    @Value(value="${spring.redis.lettuce.pool.min-idle}")
    private int minIdle;
    @Value(value="${spring.redis.lettuce.pool.max-active}")
    private int maxActive;
    @Value(value="${spring.redis.lettuce.pool.max-wait}")
    private Duration maxWait;
    @Value(value="${spring.redis.lettuce.pool.time-between-eviction-runs}")
    private Duration timeBetweenEvictionRuns;

    @Bean
    public LettuceConnectionFactory lettuceConnectionFactory() {
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(this.maxIdle);
        genericObjectPoolConfig.setMinIdle(this.minIdle);
        genericObjectPoolConfig.setMaxTotal(this.maxActive);
        genericObjectPoolConfig.setMaxWait(this.maxWait);
        genericObjectPoolConfig.setTimeBetweenEvictionRuns(this.timeBetweenEvictionRuns);
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setDatabase(this.database);
        redisStandaloneConfiguration.setHostName(this.host);
        redisStandaloneConfiguration.setPort(this.port);
        redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.password));
        LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().commandTimeout(Duration.ofMillis(this.timeout)).shutdownTimeout(Duration.ofMillis(this.shutDownTimeout)).poolConfig(genericObjectPoolConfig).build();
        LettuceConnectionFactory factory = new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)clientConfig);
        return factory;
    }

    @Bean
    public RedisTemplate<Object, Object> redisTemplate(LettuceConnectionFactory lettuceConnectionFactory) {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        GenericJackson2JsonRedisSerializer genericJackson2JsonRedisSerializer = new GenericJackson2JsonRedisSerializer();
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)lettuceConnectionFactory);
        redisTemplate.setDefaultSerializer((RedisSerializer)stringSerializer);
        redisTemplate.setEnableDefaultSerializer(true);
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)genericJackson2JsonRedisSerializer);
        redisTemplate.setHashValueSerializer((RedisSerializer)genericJackson2JsonRedisSerializer);
        return redisTemplate;
    }

    @Bean
    public CacheManager cacheManager(LettuceConnectionFactory lettuceConnectionFactory) {
        RedisCacheConfiguration redisCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        redisCacheConfiguration = redisCacheConfiguration.serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new StringRedisSerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new GenericJackson2JsonRedisSerializer())).disableCachingNullValues().entryTtl(Duration.ofHours(24L));
        RedisCacheManager redisCacheManager = RedisCacheManager.builder((RedisConnectionFactory)lettuceConnectionFactory).cacheDefaults(redisCacheConfiguration).transactionAware().build();
        return redisCacheManager;
    }
}

