/*
 * Decompiled with CFR 0.152.
 */
package io.github.nier6088.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(basePackages={"com.boolib.simple.mapper"})
public class GlobalMybatisPlusConfig
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalMybatisPlusConfig.class);

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.MYSQL));
        return interceptor;
    }

    public void insertFill(MetaObject metaObject) {
        String property = metaObject.findProperty("record_status", true);
        if (StringUtils.isNotBlank((CharSequence)property)) {
            this.strictInsertFill(metaObject, property, Integer.class, 1);
        }
        this.strictInsertFill(metaObject, "createTime", Date.class, new Date());
    }

    public void updateFill(MetaObject metaObject) {
        this.setFieldValByName("modifyTime", new Date(), metaObject);
    }
}

